//
// Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description: 
// This example is used to demonstrate the utilities of the System State Manager
// framework.

#ifndef __SSMANAGER_H__
#define __SSMANAGER_H__

#include <e32cons.h>
#include <ssm/ssmcommandlist.h>
#include <ssm/ssmstatemanager.h>
#include <ssm/ssmsystemwideproperty.h>

/**
CSysStateManagerExample demonstrates the various utilities of the System State Manager.
1 - Requesting a change in a System Wide Property (SwP) or in System State (SS),
2 - Notifying the client about a change in a System Wide Property (SwP) or in System State (SS)
*/

class CSysStateManagerExample : public CBase, public MSwpChangeNotificationSubscriber
	{			
public:
	static CSysStateManagerExample* NewLC();
	~CSysStateManagerExample();
	void SSManagerL();
	void RequestSwpChange();
	void RequestSsChange();
	void RequestSwpChangeWithNotificationL();
	void RequestSsChangeWithNotification();
	
	//from MSwpChangeNotificationSubscriber
	void SwpChanged(TSsmSwp aSwp);	
private:
	CSysStateManagerExample();	
public:
	CConsoleBase* iConsole;
	RSsmStateManager iSsmStateManager;
	};

#endif  //__SSMANAGER_H__
