//
// Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description: 
// Dummy Disk status policy is used to demonstrate a System Wide Property
// policy file. It executes a command list which can start a process dummybackup.exe,
// depending on the value of the dummy disk status policy.


#ifndef __DUMMY_DISKSTATUS_SWPPOLICY_H__
#define __DUMMY_DISKSTATUS_SWPPOLICY_H__

#include <e32cons.h>
#include <f32file.h>

#include <ssm/ssmswppolicy.h>
#include <ssm/ssmconditionalcallback.h>

// Forward declare
class CSsmCommandListResourceReader;

/**
Demonstrates the implementation of a System Wide Property Policy. 
The command list is prepared by this class using the information provided in a resource file.
@see MSsmSwpPolicy
@see MSsmConditionalCallback
*/

NONSHARABLE_CLASS(CSsmDummyDiskStatusSwpPolicy) : public CBase, public MSsmSwpPolicy, public MSsmConditionalCallback
	{
public:
	IMPORT_C static MSsmSwpPolicy* NewL(); 
	
	//from MSsmSwpPolicy
	void ConstructL();
	void Initialize(TRequestStatus& aStatus);
	void InitializeCancel();
	void Release();
	TResponse TransitionAllowed(const TSsmSwp& aSwp, const RMessagePtr2& aMessage);
	void PrepareCommandList(const TSsmSwp& aSwp, TRequestStatus& aStatus);
	void PrepareCommandListCancel();
	CSsmCommandList* CommandList();
	void HandleCleReturnValue(const TSsmSwp& aSwp, TInt aError, TInt aSeverity, TRequestStatus& aStatus);
	void HandleCleReturnValueCancel();
	
	//from MSsmConditionalCallback
	TBool ConditionalCommandAllowedL(CResourceFile& aResourceFile, TInt aResourceId);
	
private:
	//from CBase
	CSsmDummyDiskStatusSwpPolicy();
	~CSsmDummyDiskStatusSwpPolicy();

private:
	RFs iFs;
	CSsmCommandListResourceReader* iCommandListResourceReader;
	// Possible panic codes within Disk Status policy
	enum TDiskStatusPanicCodes
		{
		EInvalidResourceReader //Panic when command list resource reader is NULL
		};
	};

#endif  //__DUMMY_DISKSTATUS_SWPPOLICY_H__
