//
// Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description: A dummy backup state policy is provided to demonstrate the system state
// manager framework.
//

#ifndef _DUMMY_BACKUP_STATEPOLICY_H__
#define _DUMMY_BACKUP_STATEPOLICY_H__

#include <e32base.h>
#include <f32file.h>

#include <ssm/ssmstatepolicy.h>
#include <ssm/ssmstate.h>
#include <ssm/ssmconditionalcallback.h>
#include <ssm/ssmstatetransition.h>

// Forward declaration
class CSsmCommandListResourceReader;

/**
Demonstrates the implementation of a Dummy Backup System State Policy. 
The command list is prepared in this class from a resource file.
@see MSsmStatePolicy
@see MSsmConditionalCallback
*/
NONSHARABLE_CLASS(CSsmDummyBackUpStatePolicy) : public CBase, public MSsmStatePolicy, public MSsmConditionalCallback
	{
public:
	IMPORT_C static MSsmStatePolicy* NewL();
	
	//from MSsmStatePolicy
	void Initialize(TRequestStatus& aStatus);
	void InitializeCancel();
	void Release();
	TResponse TransitionAllowed(const TSsmStateTransition& aRequest, TSsmStateTransition const* aCurrent, TSsmStateTransition const* aQueued, const RMessagePtr2& aMessage);
	void PrepareCommandList(TSsmState aState, TInt aReason, TRequestStatus& aStatus);
	void PrepareCommandListCancel();
	CSsmCommandList* CommandList();
	TBool GetNextState(TSsmState aCurrentTransition, TInt aReason, TInt aError, TInt aSeverity, TSsmState& aNextState);
	
	//from MSsmConditionalCallback
	TBool ConditionalCommandAllowedL(CResourceFile& aResourceFile, TInt aResourceId);
	
private:
	void ConstructL();
	//from CBase
	CSsmDummyBackUpStatePolicy();
	~CSsmDummyBackUpStatePolicy();
	TBool TransitionSupported(const TSsmState& aRequestedState) const;
private:
	RFs iFs;
	CSsmCommandListResourceReader* iCommandListResourceReader;
	RArray<TSsmState> iCurrentlySupportedTransitions;
	enum TBackupPanicCodes
		{
		EInvalidResourceReader // Panic code used when the command list resource reader is NULL
		};
	};

#endif  //_DUMMY_BACKUP_STATEPOLICY_H__
