//
// Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description: A dummy restore state policy is provided to demonstrate the 
// system state manager framework.
//

#ifndef __DUMMY_RESTORE_STATEPOLICY_H__
#define __DUMMY_RESTORE_STATEPOLICY_H__

#include <e32base.h>
#include <ssm/ssmstatepolicy.h>
#include <ssm/ssmstate.h>

/**
Demonstrates the implementation of a System State Policy. 
The command list is prepared using the command factory class.
*/

NONSHARABLE_CLASS(CSsmDummyRestoreStatePolicy) : public CBase, public MSsmStatePolicy
	{
public:
	IMPORT_C static MSsmStatePolicy* NewL(); 
	
	//from MSsmStatePolicy
	void Initialize(TRequestStatus& aStatus);
	void InitializeCancel();
	void Release();
	TResponse TransitionAllowed(const TSsmStateTransition& aRequest, TSsmStateTransition const* aCurrent, TSsmStateTransition const* aQueued, const RMessagePtr2& aMessage);
	void PrepareCommandList(TSsmState aState, TInt aReason, TRequestStatus& aStatus);
	void doPrepareCommandListL(TSsmState aState);
	void PrepareCommandListCancel();
	CSsmCommandList* CommandList();
	TBool GetNextState(TSsmState aCurrentTransition, TInt aReason, TInt aError, TInt aSeverity, TSsmState& aNextState);
	
private:
	//from CBase
	CSsmDummyRestoreStatePolicy();
	~CSsmDummyRestoreStatePolicy();

private:
	CSsmCommandList* iCommandList;
	};

#endif //__DUMMY_RESTORE_STATEPOLICY_H__
