//
// Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description: 
// Extends the GSA (Generic Startup Architecture) normal policy to  
// to support the dummy backup and restore states added as part of this example. 
// The example uses this extended normal state, which replaces the existing normal policy.

#ifndef __GSASTATEPOLICYNORMAL_H__
#define __GSASTATEPOLICYNORMAL_H__

#include <e32base.h>
#include <ssm/ssmstatepolicy.h>
#include <ssm/ssmconditionalcallback.h>

class CSsmCommandListResourceReader;

/**
Normal state policy plug-in for GSA. This is a polymorphic dll.

It implements MSsmStatePolicy to initialize, prepare, and return a command list using CSsmCommandListResourceReader.
It implements MSsmConditionalCallback to decide whether to include a command in a command list or not.
@see MSsmStatePolicy
@see MSsmConditionalCallback
*/
NONSHARABLE_CLASS(CEgGsaStatePolicyNormal) : public CBase, public MSsmStatePolicy, public MSsmConditionalCallback
	{
public:
	IMPORT_C static MSsmStatePolicy* NewL();

	//from MSsmStatePolicy
	TResponse TransitionAllowed(const TSsmStateTransition& aRequest, TSsmStateTransition const* aCurrent, TSsmStateTransition const* aQueued, 
								const RMessagePtr2& aMessage);
	void Initialize(TRequestStatus& aStatus);
	void InitializeCancel();
	void PrepareCommandList(TSsmState aState, TInt aReason, TRequestStatus& aStatus);
	void PrepareCommandListCancel();
	CSsmCommandList* CommandList();
	TBool GetNextState(TSsmState aCurrentTransition, TInt aReason, TInt aError, TInt aSeverity, TSsmState& aNextState);
	void Release();

	// from MSsmConditionalCallback
	TBool ConditionalCommandAllowedL(CResourceFile& aResourceFile, TInt aResourceId);
	
private:
	~CEgGsaStatePolicyNormal();
	CEgGsaStatePolicyNormal();

	void ConstructL();
	TBool TransitionSupported(const TSsmState& aRequestedState) const;

private:
	RArray<TSsmState> iCurrentlySupportedTransitions;	
	CSsmCommandListResourceReader* iCommandListResourceReader;
	RFs iFs;

	// Possible panic codes within Normal policy
	enum TNormalPanicCodes
		{
		/**
		 Panic when command list resource reader is NULL
		*/
		EInvalidResourceReader = 1,
		/**
		 Panic when Main state supplied is not 'ESsmNormal'
		*/
		EInvalidNormalState,
		/**
		 Panic when ConditionalCommandAllowedL is called for a command which has not implemented conditional_information
		*/
		EConditionalInfoNotImplemented
		};
	};

#endif	// __GSASTATEPOLICYNORMAL_H__
