//dummy_backup.cpp
//
// Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description: this is a dummy back up application which gets launched when  
// the System State changes to Back-Up state. This prints a series of console statements.
//

#include <e32cons.h>

_LIT(KTxtExampleCode,"SsManagerExample");
_LIT(KTextPressAnyKey," [press any key]");

static void  callExampleL() 
    {
    _LIT(KTxtBackUp,"\n Backing up all the Contacts \n \
                     Backing up all the Messages \n \
                     Backing up all the Multimedia files \n \
    		         Backing up all the other files \n \
    		         Back up of all files successfully completed \n");
    CConsoleBase* console = Console::NewL(KTxtExampleCode,TSize(KConsFullScreen,KConsFullScreen));
	console->Printf(KTxtBackUp);
	console->Printf(KTextPressAnyKey);
	console->Getch(); // Get and ignore character.
	delete console; // delete the console object.
    }

extern TInt  E32Main()
    {
	__UHEAP_MARK;
	CTrapCleanup* cleanup=CTrapCleanup::New(); // Get clean-up stack.
	if(cleanup!=NULL)
		{
		TRAPD (error,callExampleL());
		__ASSERT_ALWAYS(!error,User::Panic(KTxtExampleCode,error));
		}
	delete cleanup; // Destroy clean-up stack.
	__UHEAP_MARKEND;
	return KErrNone;
    }
