// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the implementation of functions defined in the RSecureSession class.
//



/**
 @file
*/

#include "secureclientandserver.h"
#include "secureclient.h"

/**
Constructor.
*/
RSecureSession::RSecureSession()
	{
	}

/**
Connects to the server using 4 message slots.
This creates a new session with the server.
In this example, the server is implemented as a separate thread. If the server is not running, the function starts the server before it tries to create a session with it.
The version information defines the lowest version of the server with which this client is compatible. Version compatibility is checked when the server side session is created. In this example, the version of the server and the version requested by the client are the same. This is because they are defined by constants common to the client source code and the server source code.
In a real application, versions would be defined independently.
@return KErrNone, if successful; otherwise, the value returned by StartThread() or CreateSession() if they were unsuccessful.
@see StartThread()
@see CSecureServer::NewSessionL()
@see RSecureSession::Version()
*/
TInt RSecureSession::Connect()
	{
	TInt r = StartThread(iServerThread);
	if (r == KErrNone)
		{
		r = CreateSession(KSecureServerName,Version(),KDefaultMessageSlots);
		}
	return(r);
	}

/**
Gets the lowest version of the server with which this client is compatible.
This is a client-side definition. If the server version is lower than this value, connection fails. In a real application, this is how a client can make sure that the server can provide the services that the client expects. The design of the client-server framework assumes that newer versions of a server are backward compatible with older versions of the server.
@return The version of the server that this client requires.
*/
TVersion RSecureSession::Version(void) const
	{
	return(TVersion(KSecureServMajorVersionNumber,KSecureServMinorVersionNumber,KSecureServBuildVersionNumber));
	}

/**
Deletes all handles associated with session.
*/
void RSecureSession::Close()
	{
	SendReceive(ESecureServerCloseSession);
	RHandleBase::Close();
	iServerThread.Close();
	}

/**
Gets the resource count from the server.
The resource count is the number of subsessions attached to the session.
@return The resource count.
*/
TInt RSecureSession::ResourceCountL()
	{
	TInt count = 0;
	TPckgBuf<TInt> pckgcount;
	TIpcArgs args(&pckgcount);
	User::LeaveIfError(SendReceive(ESecureServerResourceCount, args));
	count = pckgcount();
	return count;
	}
