// MMFExPcm8Pcm16Codec.h
// Copyright (c) 1997-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef __EXPCM8_PCM16_CODEC_H__
#define __EXPCM8_PCM16_CODEC_H__

#include <mmf/server/mmfcodec.h>

// Declares a MMF plug-in codec that converts
// from PCM8 format to PCM16
class CMMFExPcm8Pcm16Codec : public CMMFCodec
	{
public:
	// Construction
	static CMMFCodec* NewL(TAny* aInitParams);
	// Implement CMMFCodec
	TCodecProcessResult ProcessL(const CMMFBuffer& aSrc, CMMFBuffer& aDst);

private:
	// Helper function
	void Convert(TUint8* aSrc, TUint8* aDst, TInt aSamples);

private:
	//owned by the Datapath
	const CMMFDataBuffer* iSrc;
	CMMFDataBuffer* iDst;
	};

#endif
