/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef __BLUETOOTH_INFO_H__
#define __BLUETOOTH_INFO_H__

#include <e32base.h>
#include "btdiscoverer.h"

// CLASS DECLARATION

 /*!
 *  TBluetoothInfo represents Bluetooth device's data. 
 * 
 */
class TBluetoothInfo
	{
public:

 /*!
 * TBluetoothInfo()
 *
 * discussion Destructor.
 * param aName is the name of a bluetooth device.
 * param aAddress is the address of a bluetooth device.
 *
 */
	TBluetoothInfo(TDes& aName, TDes& aAddress);

/*!
 * GetDeviceName()
 *
 * discussion Gets name of bluetooth device.
 * param aName is a reference which the name of a bluetooth device
 * is copied
 * 
 */
	void GetDeviceName(TDes& aName);

/*!
 * 	void GetAddressHex()
 *
 * discussion Gets address of bluetooth device.
 * param aAddress is the reference which  the address of a bluetooth device
 * is copied.
 * 
 */
	void GetAddressHex(TDes& aAddress);

/*!
 * SetDeviceName()
 *
 * discussion Sets the name of a bluetooth device
 * param aName is the name of a bluetooth device
 * 
 */
	void SetDeviceName(TDes& aName);

/*!
 * SetAddressHex()
 *
 * discussion Sets the address of a bluetooth device.
 * param aAddress is the address of a device 
 * 
 */
	void SetAddressHex(TDes& aAddress);

private: // member data
	
    // the name of a bluetooth device
	TBuf <KBTDeviceLength> iDeviceName;
    // the address of a bluetooth device
	TBuf <KBTDeviceAddress> iHexAddress;
	};

#endif // __BLUETOOTH_INFO_H__
