/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef __BT_REFRESH_TIMER_H__
#define __BT_REFRESH_TIMER_H__

// INCLUDES
#include "e32base.h" //CTimer
#include <badesca.h>
#include "SharedIntermediator.h"
#include "BluetoothRefreshTimer.h"

//FORWARD DECLARATIONS
class CBTDiscoverer;

const TInt KRefreshTimeMin = 5;
const TInt KRefreshTimeDefault = 20; 

// CLASS DECLARATION

/**
*  CBluetoothRefreshTimer refreshes bluetooth device list.
*/
class CBluetoothRefreshTimer :
	public CTimer
	{
public: 

/*!
* NewL()
* 
* discussion Create new CBluetoothRefreshTimer object
* param aSMediator a shared intermediator.
* param aWait a scheduler loop owner.
* return a pointer to the created instance of CBluetoothRefreshTimer
*/
	static CBluetoothRefreshTimer* NewL( CSharedIntermediator* aSMediator,
	                                            CActiveSchedulerWait* aWait );

/*!
* NewLC() 
*/
	static CBluetoothRefreshTimer* NewLC( CSharedIntermediator* aSMediator,
	                                             CActiveSchedulerWait* aWait );

/*!
* Destructor
*/
	~CBluetoothRefreshTimer();

/*!
* DoCancelL()
*
* discussion Cancels the timer.
*/
	void DoCancel();

/*!
* RunL()
*
* discussion Implementation of the timer's virtual method. Check that all
* threads are alive and running, if not then restart them.
*/
	void RunL();

/*!
* RunError()
*
* discussion Handles a leave occurring in the request completion event handler
* RunL() 
* return returns always KErrNone.
*/
	TInt RunError(TInt aError);

/*!
* StartL()
*
* discussion Start searching for bluetooth devices. Activate refresh timer.
*/
	void StartL();

/*!
* StopWaitLoop()
*
* discussion Stop active scheduler wait loop. 
*/
	void StopWaitLoop();	

/*!
* SetRefreshTime()
*
* discussion Set new refresh time.
* param aRefreshTime a new refresh time in seconds.
*/
	void SetRefreshTime(TInt aRefreshTime);

private: // Basic two-phase Symbian OS constructors

/*!
 * ConstructL()
 */
	void ConstructL();

/*!
 * CBluetoothRefreshTimer()
 *
 * discussion contructor.
 * param aSMediator a shared intermediator.
 * param aWait a scheduler loop owner.
 */
	CBluetoothRefreshTimer( CSharedIntermediator* aSMediator,  
                              CActiveSchedulerWait* aWait );
	
private: // data members    

	// Scheduler loop owner
	CActiveSchedulerWait* iWait;

	// Data intermediator
	CSharedIntermediator* iSMediator;

	// Bluetooth device discoverer
	CBTDiscoverer* iBTDiscoverer;

	// Time between refresh
	TInt iRefreshTime;

	// Time that has passed from the previous refresh
	TInt iTime;
	};

#endif // __BT_REFRESH_TIMER_H__
