/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef __BT_DISCOVERER_H__
#define __BT_DISCOVERER_H__

//INCLUDES
#include <e32base.h>
#include <btsdp.h> 
#include <e32std.h>
#include <btextnotifiers.h> // TBTDeviceResponseParamsPckg
#include <bt_sock.h>
#include <BTDevice.h>
#include <es_sock.h> //RHostResolver
#include <badesca.h>


const TInt KBTDeviceLength = 40;
const TInt KBTDeviceAddress = 40; 

// FORWARD DECLARATIONS
class CSharedIntermediator;

// CLASS DECLARATION

/**
*  CBTDiscoverer Finds bluetooth devices. 
*/
class CBTDiscoverer: public CActive
	{
public:
	
/*!
 * NewL()
 * 
 * discussion Create new CBTDiscoverer object
 * param aSMediator Pointer to CSharedMediator.
 * return a pointer to the created instance of CBTDiscoverer
 */
    static CBTDiscoverer* NewL(CSharedIntermediator* aSMediator);
    
/*!
 * NewLC() 
 */
    static CBTDiscoverer* NewLC(CSharedIntermediator* aSMediator);

/*!
 * ~CBTDiscoverer()
 *
 * Destructor.
 */
	~CBTDiscoverer();
        
   // From CActive
   void RunL();
   TInt RunError(TInt aError);
   void DoCancel();

 /*!
 * void StartDiscoveringDevicesL()
 *
 * discussion Find all bluetooth devices in the vicinity.
 */
   void StartDiscoveringDevicesL();

 /*!
 * void RefreshDevices();
 *
 * discussion Refresh the Bluetooth device search. Do the search again. 		  
 */
   void RefreshDevices();
    
/*!
 * CArrayPtrFlat< HBufC >* GetNames()
 *
 * discussion Get Bluetooth device names.
 * return a pointer to list.
 */
   CArrayPtrFlat< HBufC >* GetNames();

 /*!
 * CArrayPtrFlat< HBufC >* GetDeviceAddress()
 *
 * discussion Get Bluetooth device addresses.
 * return a pointer to list.
 */
   CArrayPtrFlat< HBufC >* GetDeviceAddress();

private: // Basic two-phase Symbian OS constructors

/*!
 * CBTDiscoverer();
 *
 * Constructor.
 */
	CBTDiscoverer(CSharedIntermediator* aSMediator);

/*!
 * ConstructL()
 */
	void ConstructL();
	
private: //functions

/*!
 * void PushListL()
 *
 * discussion Get Bluetooth device addresses.
 * param aNamEntry name of the device.
 */
	void PushListL(TNameEntry& aNameEntry); 

/*!
 * void TransformSockAddressL()
 *
 * discussion Transform TInquirySockAddr.		  
 * param aInquirySockAddr address to be transformed.
 */
	void TransformSockAddressL(TInquirySockAddr& aInquirySockAddr);
	
private: // member data

	// Socket addresses
	RArray<TInquirySockAddr> iInqSockAddrArray; 

	// BT addresses in format XX-XX-XX-XX-XX-XX  
	CArrayPtrFlat< HBufC >* iDeviceAddress;

	// Device names
	CArrayPtrFlat< HBufC >* iDeviceNames;
	
	// Handle to the socket server 
	RSocketServ iSocketServer; 

	// Provides an interface to host name resolution services
	RHostResolver iHostResolver; 

	// Socket address class used for remote device inquiries
	TInquirySockAddr iSockAddr; 

	// Contains the results of name queries.
	TNameEntry iNameEntry; 

	// Shared class that transmits data between main thread and thread one
	CSharedIntermediator* iSMediator;
	};

#endif // __BT_DISCOVERER_H__ 
