/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef __DEVICE_LIST_CONTAINER_H__
#define __DEVICE_LIST_CONTAINER_H__

// INCLUDES
#include <badesca.h>	// CDesCArray
#include <coecntrl.h>	// CCoeControl
#include <eiklbo.h>	    // MEikListBoxObserver

// FORWARD DECLARATIONS
class CAknSingleStyleListBox;
class CSharedIntermediator;
class CThreadAOAppUi;

// CLASS DECLARATION

/*!
*
* CDeviceListContainer Container control class.
* 
*/
class CDeviceListContainer : public CCoeControl, MEikListBoxObserver
	{
public: // Constructors and destructor

	static CDeviceListContainer* NewL(const TRect& aRect);
	static CDeviceListContainer* NewLC(const TRect& aRect);
	~CDeviceListContainer();

public: // members

/*!
 * ShowSelectedAddressL()
 *
 * discussion show bluetooth device address of the selected bluetooth device.
 *
 */
	void ShowSelectedAddressL();

/*!
 * AddItemL()
 *
 * discussion Show bluetooth device address of the selected bluetooth device.
 * param aNewItem item to be displayed in the listbox.
 */
	void AddItemL(const TDesC& aNewItem);

/*!
 * SetSMediator()
 *
 * discussion Set shared mediator that is used to fetch bluetooth device
 * address. param aSMediator a shared mediator.
 */
	void SetSMediator(CSharedIntermediator* aSMediator);

 /*!
 * ClearListBox()
 *
 * discussion clear listbox screen.
 */
	void ClearListBox();

 /*!
 * HandleChanged()
 *
 * discussion redraw listbox.
 */
	void HandleChangedL();

private: // members
	
 /*!
 * CreateScrollBarsL()
 *
 * discussion create listbox scrollbars.
 */
	void CreateScrollBarsL();

private: // constructor

	CDeviceListContainer();
	void ConstructL(const TRect& aRect);

private: // from MEikListBoxObserver

 /*!
 * HandleListBoxEventL()
 *
 * discussion Handles listbox event.
 * param aListBox Pointer to ListBox object is not used.
 * param aEventType Type of listbox event.
 */
	void HandleListBoxEventL( CEikListBox* aListBox,
                                     TListBoxEvent aListBoxEvent );

private: // from CoeControl

 /*!
 * SizeChanged()
 *
 * discussion From CoeControl, Called by framework when the view size is
 * changed.
 */
	void SizeChanged();
	void HandleResourceChange(TInt aType);	

 /*!
 * CountComponentControls()
 *
 * discussion From CoeControl, returns number of components.
 * return Number of controls.
 */
	TInt CountComponentControls() const;

/*!
 * ComponentControl()
 *
 * discussion From CCoeControl, returns pointer to particular component.
 * param aIndex Index of the control.
 * return Pointer to Control's component control, identified by index.
 */
	CCoeControl* ComponentControl(TInt aIndex) const;
	
 /*!
  * Draw()
  *
  * discussion From CCoeControl, fills the window's rectangle.
  * param aRect Region of the control to be (re)drawn.
  */
	void Draw(const TRect& aRect) const;

  /*!
  * OfferKeyEventL()
  *
  * discussion From CoeControl, handles the key-events.
  * param aKeyEvent Key event.
  * param aType Type of key event(EEventKey, EEventKeyUp or EEventKeyDown).
  * return If key-event is consumed, EKeyWasConsumed, else EKeyWasNotConsumed
  */
	TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent, TEventCode aType);

private: //member data

    // Listbox
	CAknSingleStyleListBox* iDeviceListBox; 
	// Shared class which main program and thread use
	CSharedIntermediator* iSMediator;
	};

#endif	// #ifndef __DEVICE_LIST_CONTAINER_H__
