/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef __LISTBOX_REFRESH_TIMER_H__
#define __LISTBOX_REFRESH_TIMER_H__

// INCLUDES
#include "e32base.h" //CTimer

// CLASS DECLARATION
class CDeviceListContainer;

/**
*  CListboxRefreshTimer Updates listbox screen.
*/
class CListboxRefreshTimer :
	public CTimer
	{

public: 

/*!
* NewL()
* 
* Create new CListboxRefreshTimer object
* param aListBox pointer to a ListBox that needs refreshing. 
* return a pointer to the created instance of CListboxRefreshTimer.
*/
	static CListboxRefreshTimer* NewL(CDeviceListContainer* aListBox);

/*!
* NewLC()
*	 
*/
	static CListboxRefreshTimer* NewLC(CDeviceListContainer* aListBox);

/*!
* Destructor
*	 
*/
	~CListboxRefreshTimer();

/*!
* DoCancelL()
*
* Cancels the timer.
*/
	void DoCancel();

/*!
* RunL()
*
* Implementation of the timer's virtual method. Update listboxes screen.
*/
	void RunL();

/*!
* RunError()
*
* Handles a leave occurring in the request completion event handler RunL().
* return returns always KErrNone.
*/
	TInt RunError(TInt aError);

/*!
* StartL()
*
* Start updating the listbox.
*/
	void StartL();

private: // Basic two-phase Symbian OS constructors

/*!
 * ConstructL()
 *
 */
	void ConstructL();

/*!
 * CListboxRefreshTimer()
 *
 *  Constructor.
 */
	CListboxRefreshTimer(CDeviceListContainer* aListBox);
	
private: // data members    

	// The listbox which shows bluetooth devices names
	CDeviceListContainer* iListbox;
	};

#endif // __LISTBOX_REFRESH_TIMER_H__
