/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef __SHARED_INTERMEDIATOR_H__
#define __SHARED_INTERMEDIATOR_H__

#include <e32std.h>
#include <e32base.h>
#include <badesca.h> // CArrayFixFlat

// FORWARD DECLARATIONS
class TBluetoothInfo;
class CDeviceListContainer;
class CBluetoothRefreshTimer;
class CThreadAOAppUi;

// CLASS DECLARATION

 /*!
 *  CSharedInterMediator Transmits data between main program and thread one,
 * Thread one reads commands, which are given in UI (main program).
 */
class CSharedIntermediator : public CBase
	{
public:
	
 /*!
 * NewL()
 * 
 * discussion Create new CSharedIntermediator object.
 * param aView is a UI's container.
 * return a pointer to the created instance of CSharedIntermediator.
 */
	static CSharedIntermediator* NewL(CDeviceListContainer* aView);

 /*!
 * NewLC()
 *	 
 */
	static CSharedIntermediator* NewLC(CDeviceListContainer* aView);

 /*!
 * ~CSharedIntermediator()
 *
 * discussion Destructor.
 *
 */
	~CSharedIntermediator();

 /*!
 * AddBluetoothInfoL()
 *
 * discussion Add TBluetoothInfo object into iBluetoothInfoArray which
 * contains bluetooth device's data  and adds new bluetooth device's
 * name into UI's list box.
 * param aNamEntry name of the device.
 */
	void AddBluetoothInfoL(TBluetoothInfo& aBtInfoElement);

/*!
 * DeviceListContainer()
 *
 * discussion Clears bluetooth info array.
 */
	void ResetArray();

 /*!
 * GetAddress()
 *
 * discussion Get bluetooth device address from iBluetoothInfoArray.
 * param Address Returned a bluetooth device address.
 * param aIndex valid index of iBluetoothInfoArray.
 */
	void GetAddress(TDes& aAddress, TInt aIndex);

 /*!
 * SetStopSearching()
 *
 * discussion Set class member variable, which tells to thread
 * that Activescheduler's wait loop should stop. After that thread cleans up
 * itself and is terminated "naturally".
 * param aStopSearching new value for parameter iStopSearching.
 */
	void SetStopSearching(bool aStopSearching);

 /*!
 * StopSearching()
 *
 * discussion  Get class member variable, which tells to thread
 * that Activescheduler's wait loop should stop.
 * return True when program should be closed, false otherwise.
 */
	TBool StopSearching();

 /*!
 * BTRefreshTimerPtr()
 *
 * discussion Get thread's bluetooth refresh timer pointer. New refresh time
 * is set in main program. 
 * return thread one's bluetooth refresh timer pointer.
 */
	CBluetoothRefreshTimer* BTRefreshTimerPtr();

 /*!
 * SetBTRefreshTimerPtr()
 *
 * discussion Set thread's bluetooth refresh timer pointer. New refresh time
 * is set in main program. 
 * param aTimer is bluetooth discovery refresh timer.
 * 
 */
	void SetBTRefreshTimerPtr(CBluetoothRefreshTimer* aTimer);

 /*!
 * DeviceListContainer()
 *
 * discussion Get UI's container pointer. Function is used
 * when thread one CBTRefreshTimer clears UI's listbox.
 * return thread one bluetooth refresh timer pointer.
 */
	CDeviceListContainer* DeviceListContainer();

/*!
 * SetRefreshTimerInitlVal()
 *
 * discussion Set CBTRefreshTimer's initial refresh time.
 * param aRefreshTime is a new refresh time.
 */
	void SetRefreshTimerInitlVal(TInt aRefreshTime);

/*!
 * SetRefreshTimerInitlVal()
 *
 * discussion Get CBTRefreshTimer's initial refresh time.
 * return CBTRefreshTimer instance's initial time.
 */
	TInt RefreshTimerInitlVal();

private: // // Basic two-phase Symbian OS constructors

/*!
 * CSharedIntermediator()
 *
 * discussion Constructor.
 * param aView is an UI's container
 */
	CSharedIntermediator(CDeviceListContainer* aView);
	
 /*!
 * ConstructL()
 */
	void ConstructL();

private: // data members

	// UI's container, that shows listbox
	CDeviceListContainer* iDeviceListContainer;
    // True when program should be closed, false otherwise
	TBool iStopSearching;
    // Pointer to thread's blueetooth discoveryrefresh timer
	CBluetoothRefreshTimer* iBTRefreshTimer;
    // iBluetoothInfoArray is synchronized i.e. thread safe
	RMutex iMutex;
	// Contains all found bluetooth devices
	CArrayFixFlat <TBluetoothInfo>* iBluetoothInfoArray;
	// CBTRefreshTimer initial refresh time
	TInt iInititialRefreshTime;
	};

#endif	//__SHARED_INTERMEDIATOR_H__
