/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef __THREADAO_APPUI_H__
#define __THREADAO_APPUI_H__

// INCLUDES
#include <aknappui.h>

// FORWARD DECLARATIONS
class CThreadAOEngine;
class CDeviceListContainer;
class CSharedIntermediator;
class CListboxRefreshTimer;

// CLASS DECLARATION

/**
* An instance of class CThreadAppUi is the UserInterface part of the AVKON
* application framework for the Thread example application
*/
class CThreadAOAppUi : public CAknAppUi
    {
public:

	/*!
	*  ConstructL()
	*  
	*  discussion Perform the second phase construction of a CThreadAOAppUi object.
	*  This needs to be public due to the way the framework constructs the AppUi 
	*/
    void ConstructL();

	/*!
	*  CThreadAOAppUi()
	*  
	*  discussion Perform the first phase of two phase construction.
	*  This needs to be public due to the way the framework constructs the AppUi 
	*/
    CThreadAOAppUi();

	/*!
	* ~CThreadAOAppUi
	*  
	*  discussion Destroy the object
	*/
    ~CThreadAOAppUi();

public: // from CAknAppUi
	/*!
	* HandleCommandL()
	*  
	*  discussion Handle user menu selections
	*  param aCommand The enumerated code for the option selected
	*/
    void HandleCommandL(TInt aCommand);

private:
	/**
	 * From CEikAppUi,
	 */
	void HandleStatusPaneSizeChange();   

private:
    TBool TurnBtOnL();
	
private:  //member data

	// Container of the view
	CDeviceListContainer* iContainer;

	// Shared intermediator. Transmits data between thread1 and the mainthread
	CSharedIntermediator* iSMediator;

	// Thread engine
	CThreadAOEngine* iThreadEngine;

	// True if the bluetooth search has been activated, false otherwise
	TBool iThreadStarted;

	// Listbox refresher
	CListboxRefreshTimer* iTimer;
	};

#endif // __THREAD_APPUI_H__
