/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef __THREAD_DOCUMENT_H__
#define __THREAD_DOCUMENT_H__

// INCLUDES
#include <akndoc.h>

// FORWARD DECLARATIONS
class CThreadAOAOAppUi;
class CEikApplication;

// CLASS DECLARATION

/*!
* discussion An instance of class CThreadAODocument is the Document part of
* the AVKON application framework for the ThreadAO example application
*/
class CThreadAODocument : public CAknDocument
    {
public:

/*!
*  NewL()
*  
*  discussion Construct a CThreadAODocument for the AVKON application aApp 
*  using two phase construction, and return a pointer to the created object
*  param aApp The application creating this document
*  result A pointer to the created instance of CThreadAODocument
*/
    static CThreadAODocument* NewL(CEikApplication& aApp);

/*!
*  NewLC()
*  
*  discussion Construct a CThreadAODocument for the AVKON application aApp 
*  using two phase construction, and return a pointer to the created object
*  param aApp The application creating this document
*  result A pointer to the created instance of CThreadAODocument
*/
    static CThreadAODocument* NewLC(CEikApplication& aApp);

/*!
* ~CThreadAOAppView()
*  
*  discussion Destroy the object
*/
    ~CThreadAODocument();

public: // from CAknDocument
/*!
*  CreateAppUiL() 
*  
*  discussion Create a CThreadAOAppUi object and return a pointer to it
*  result A pointer to the created instance of the AppUi created
*/
    CEikAppUi* CreateAppUiL();

private: // Basic two-phase Symbian OS constructors

/*!
*  ConstructL()
*  
*  discussion Perform the second phase construction of a CThreadAODocument
*  object
*/
    void ConstructL();

/*!
*  CThreadAODocument()
*  
*  discussion Perform the first phase of two phase construction 
*  param aApp The application creating this document
*/
    CThreadAODocument(CEikApplication& aApp);
    };


#endif // __THREAD_DOCUMENT_H__
