/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef __THREAD_AO_ENGINE_H__
#define __THREAD_AO_ENGINE_H__

// INCLUDES
#include "e32base.h" //CTimer
#include "badesca.h" // CDesCaRrayFlat
#include "SharedIntermediator.h"
#include "ThreadListener.h"

// FORWARD DECLARATIONS
class SharedIntermediator;

// CLASS DECLARATION

/**
*  CThreadAOEngine application engine class.
*/
class CThreadAOEngine : public CBase
	{
public: 

/*!
* NewL()
* 
* discussion Create new CThreadAOEngine object
*
* param aSMediator a Pointer to CSharedIntermediator. 
* return a pointer to the created instance of CThreadAOEngine
*/
	static CThreadAOEngine* NewL(CSharedIntermediator* aSMediator);

/*!
* NewLC()
*	 
*/
	static CThreadAOEngine* NewLC(CSharedIntermediator* aSMediator);

/*!
* Destructor
*	 
*/
	~CThreadAOEngine();

/*!
* StartL()
*
* discussion Create thread1 and start threadFunction. Checks that this has 
* been called only once.
*/
	void StartL();

/*!
* Stop()
*
* discussion Stop thread1.  
*/
	void Stop();

/*!
* ExecuteThread()
*
* discussion Function for thread one. Thread one executes this function while
* it's running.
* param aPtr pointer to a resource.
*/
	static TInt ExecuteThreadOne(TAny *aPtr);

/*!
* CreateActiveScheduler()
*
* discussion Create ActiveScheduler for thread1. Thread1 needs scheduling, because
* it's using active objects and the framework won't implement scheduler
* for you.
* param aSMediator a Pointer to CSharedIntermediator.
*/
	static void CreateActiveSchedulerL(CSharedIntermediator* aSMediator);

private: //functions

/*!
* CreateThreadsL()
*
* discussion Initialize one thread and start it. 
*/
	void CreateThreadsL();

private: // Basic two-phase Symbian OS constructors

/*!
 * ConstructL()
 *
 */
	void ConstructL();

/*!
 * CThreadAOEngine()
 * 
 * discussion Default constructor.
 * param aSMediator a Pointer to CSharedIntermediator.
 */
	CThreadAOEngine(CSharedIntermediator* aSMediator);
	
private: // data members       
	
	// a handle for thread1
	RThread iThreadOne;

	// Create a new thread only once. True means that the thread has been created, 
	// false otherwise.
	TBool iCreatedThreads;

	// Shared intermediator. Transmits data between thread1 and the mainthread
	CSharedIntermediator* iSMediator;

	// Thread1 state listener. 
	CThreadListener* iListener;
	};

#endif // __THREAD_AO_ENGINE_H__
