/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef __THREAD_LISTENER_H__
#define __THREAD_LISTENER_H__

//INCLUDES
#include <e32base.h> //CActive
#include <e32std.h>

// CLASS DECLARATION

/**
* 
*  ThreadListener checks whether thread1 has been killed or not.
*  If thread1 has been killed, then exit the main program. 
*/
class CThreadListener: public CActive
	{
public:
	
/*!
 * NewL()
 * 
 * discussion Create new CThreadListener object
 * param aThread Handle A handle to a thread.
 * return a pointer to the created instance of CThreadListener
 */
    static CThreadListener* NewL(RThread& aThread);
    
/*!
 * NewLC()
 *	 
 */
    static CThreadListener* NewLC(RThread& aThread);

/*!
 * ~CThreadListener()
 *
 * Destructor.
 *
 */
	~CThreadListener();
        
   // From CActive
   void RunL();
   void DoCancel();
 
private: // Basic two-phase Symbian OS constructors

/*!
 * CThreadListener();
 *
 * Constructor.
 *
 */
	CThreadListener();

/*!
 * ConstructL()
 * param aThread Handle A handle to a thread.
 */
	void ConstructL(RThread& aThread);
	
private:
	RThread iMonitoredThread;
	};

#endif // __THREAD_LISTENER_H__
