/*
 * Copyright  2008 Nokia Corporation.
 */

#include "BluetoothInfo.h"

// ----------------------------------------------------------------------------
// TBluetoothInfo::TBluetoothInfo(TDes& aName, TDes& aAddress)
//
// Constructor.
// ----------------------------------------------------------------------------

TBluetoothInfo::TBluetoothInfo(TDes& aName, TDes& aAddress)
	{
    iDeviceName = aName;
    iHexAddress = aAddress;
	}

// ----------------------------------------------------------------------------
// void TBluetoothInfo::GetDeviceName(TDes& aName)
//
// Get the name of the bluetooth device.
// ----------------------------------------------------------------------------

void TBluetoothInfo::GetDeviceName(TDes& aName)
	{
	aName.Copy(iDeviceName); 
	}
// ----------------------------------------------------------------------------
// void TBluetoothInfo::GetAddressHex(TDes& aAddress)
//
// Get the address of the bluetooth device.
// ----------------------------------------------------------------------------

void TBluetoothInfo::GetAddressHex(TDes& aAddress)
	{
	aAddress.Copy(iHexAddress);
	}

// ----------------------------------------------------------------------------
// TBluetoothInfo::SetDeviceName(TDes& aName)
//
// Set the name of the bluetooth device.
// ----------------------------------------------------------------------------

void TBluetoothInfo::SetDeviceName(TDes& aName)
	{
	iDeviceName = aName;		
	}
// ----------------------------------------------------------------------------
// void TBluetoothInfo::SetAddressHex(TDes& aAddress)
//
// Set the address of the bluetooth device.
// ----------------------------------------------------------------------------

void TBluetoothInfo::SetAddressHex(TDes& aAddress)
	{
	iHexAddress  = aAddress;
	}
