/*
 * Copyright  2008 Nokia Corporation.
 */


// INCLUDE FILES

// Class include
#include "DeviceListContainer.h"
#include "SharedIntermediator.h"
#include <aknnotewrappers.h>
#include "ThreadAOAppUi.h"
#include "BTDiscoverer.h" // KBTDeviceAddress

// System includes
#include <aknlists.h>		// CAknSingleStyleListBox
#include <barsread.h>		// TResource Reader
#include <eikclbd.h>		// CColumnListBoxData
#include <eikmenub.h>		// CEikMenuBar
#include <ThreadAO.rsg>		// R_DEVICE_LIST_LISTBOX
#include <stringloader.h>	// StringLoader
#include <uikon.hrh>		// TKeyCode #defines


const TInt KAknExListAddItemBufLength(256);
#define KListBoxPosition TPoint(0,0) 

_LIT( KListBoxHeader, "Bluetooth devices:");

// ----------------------------------------------------------------------------
// CDeviceListContainer::CDeviceListContainer()
//
// Default C++ constructor.
// ----------------------------------------------------------------------------
CDeviceListContainer::CDeviceListContainer() : iSMediator(NULL)
	{	
	}

// ----------------------------------------------------------------------------
// CDeviceListContainer::ConstructL(const TRect& aRect)
//
// Symbian OS 2nd phase constructor. Creates a Window for the 
// controls, which it contains. Constructs a label and adds it to the window, 
// which it then activates.
// param aRect The rectangle for this window
// ----------------------------------------------------------------------------	
void CDeviceListContainer::ConstructL(const TRect& aRect)
	{
	 CreateWindowL();
	
	// Create the listbox
	iDeviceListBox = new (ELeave) CAknSingleStyleListBox;
	iDeviceListBox->SetContainerWindowL(*this);
	
	// Create from resource
	TResourceReader reader;
	CEikonEnv::Static()->CreateResourceReaderLC(reader, R_DEVICE_LIST_LISTBOX);
	iDeviceListBox->ConstructFromResourceL(reader);

	CleanupStack::PopAndDestroy(); // reader

	// Observe the list
	iDeviceListBox->SetListBoxObserver(this);

	// Set scroll bars
	CreateScrollBarsL();
	SetRect(aRect);
	ActivateL();

	// Use listbox first cell as a header
	AddItemL(KListBoxHeader);
	}


// ----------------------------------------------------------------------------
// CDeviceListContainer::CreateScrollBarsL()
//
// Creates vertical scrollbars for the list. Scrollbars are always visible.
// ----------------------------------------------------------------------------
void CDeviceListContainer::CreateScrollBarsL()
	{
	iDeviceListBox->CreateScrollBarFrameL();
	iDeviceListBox->ScrollBarFrame()->SetScrollBarVisibilityL(
		CEikScrollBarFrame::EOn, CEikScrollBarFrame::EOn);
	}


// ----------------------------------------------------------------------------
// Symbian OS 2 phase constructor.
//
// Constructs the CDeviceListContainer using the NewLC method, popping
// the constructed object from the CleanupStack before returning it.
// 
// ----------------------------------------------------------------------------
CDeviceListContainer* CDeviceListContainer::NewL(const TRect& aRect)
	{
	CDeviceListContainer* self = CDeviceListContainer::NewLC(aRect);
	CleanupStack::Pop(self);
	return self;
	}

// ----------------------------------------------------------------------------
// Symbian OS 2 phase constructor.
//
// discussion Constructs the CDeviceListContainer using the constructor and
// ConstructL method, leaving the constructed object on the CleanupStack before
// returning it.
// 
// ----------------------------------------------------------------------------
CDeviceListContainer* CDeviceListContainer::NewLC(const TRect& aRect)
	{
	CDeviceListContainer* self = new (ELeave) CDeviceListContainer;
	CleanupStack::PushL(self);
	self->ConstructL(aRect);
	return self;
	}

// ----------------------------------------------------------------------------
// Destructor.  Frees up memory.
// ----------------------------------------------------------------------------
CDeviceListContainer::~CDeviceListContainer()
	{
	delete iDeviceListBox;
	}

// ----------------------------------------------------------------------------
// CDeviceListContainer::SizeChanged()
//
// Called by framework when the view size is changed.
// ----------------------------------------------------------------------------
//
void CDeviceListContainer::SizeChanged()
	{
	iDeviceListBox->SetExtent( KListBoxPosition, 
	                             iDeviceListBox->MinimumSize() );
	}


// ----------------------------------------------------------------------------
// CDeviceListContainer::CountComponentControls() const
//
// Returns number of components.
// ----------------------------------------------------------------------------
//
TInt CDeviceListContainer::CountComponentControls() const
	{
	return 1;
	}

// ----------------------------------------------------------------------------
// CDeviceListContainer::ComponentControl(TInt aIndex) const
//
// Returns pointer to particular component.
// ----------------------------------------------------------------------------
//
CCoeControl* CDeviceListContainer::ComponentControl(TInt aIndex) const
	{
	switch (aIndex)
		{
		case 0:
			return iDeviceListBox;
		default:
			return NULL;
		}
	}
// ----------------------------------------------------------------------------
// CDeviceListContainer::Draw(const TRect& aRect) const
//
// Fills the window's rectangle.
// ----------------------------------------------------------------------------
//
void CDeviceListContainer::Draw(const TRect& aRect) const
	{
	CWindowGc& gc = SystemGc();
	gc.Clear(aRect);
	}


// ----------------------------------------------------------------------------
// CDeviceListContainer::OfferKeyEventL(const TKeyEvent& aKeyEvent,
// TEventCode aType)
//
// Handles the key events.
// ----------------------------------------------------------------------------
//
TKeyResponse CDeviceListContainer::OfferKeyEventL(
                                  const TKeyEvent& aKeyEvent,TEventCode aType )
	{
	if (iDeviceListBox)
		return iDeviceListBox->OfferKeyEventL (aKeyEvent, aType);
	else
		return EKeyWasNotConsumed;
	}


// ----------------------------------------------------------------------------
// CDeviceListContainer::HandleListBoxEventL(CEikListBox* aListBox, 
//                      	 TListBoxEvent aEvent)
//
// Handles listbox event.
// ----------------------------------------------------------------------------
void CDeviceListContainer::HandleListBoxEventL( CEikListBox* /*aListBox*/,
                                                         TListBoxEvent aEvent )
	{	
	// Select Key has been pressed
	if ((aEvent == MEikListBoxObserver::EEventEnterKeyPressed) ||
		(aEvent == MEikListBoxObserver::EEventItemClicked))
		{
		ShowSelectedAddressL();
		}
	}


// ----------------------------------------------------------------------------
// CDeviceListContainer::AddItemL(const TDesC& aNewItem)
//
// Add an item to the listbox.
// ----------------------------------------------------------------------------
void CDeviceListContainer::AddItemL(const TDesC& aNewItem)
	{
		
	CTextListBoxModel* model = iDeviceListBox->Model();  
	CDesCArray* deviceArray = static_cast<CDesCArray*>(model->ItemTextArray());
	
	TBuf <KAknExListAddItemBufLength> addedItem( 0 );
	
	// Listbox icon is required at the beginning of a descriptor, " \t" if
	// there is no icon.
	_LIT( beginning, " \t");
	addedItem.Append( beginning );
	addedItem.Append( aNewItem );

	// Insert a new item into the array
	deviceArray->InsertL(deviceArray->Count(), addedItem);
	}

// ----------------------------------------------------------------------------
// CDeviceListContainer::HandleChangedL()
//
// Notify that the listbox should be redrawn. 
// ----------------------------------------------------------------------------
void CDeviceListContainer::HandleChangedL()
	{
	iDeviceListBox->HandleItemAdditionL();
	}

// ----------------------------------------------------------------------------
// CDeviceListContainer::ShowSelectedAddressL()
//
// Shows bluetooth address. 
// ----------------------------------------------------------------------------
void CDeviceListContainer::ShowSelectedAddressL()
	{
	if (iDeviceListBox)
		{
		CTextListBoxModel* model = iDeviceListBox->Model(); // Not taking
		                                                    // ownership
		
		if (model->NumberOfItems() > 0)
			{
			
            // Selected item if you want to show
			TInt itemIndex = iDeviceListBox->CurrentItemIndex();			
	
			// First item in the listbox is header not tbluetoothinfo
			if (itemIndex > 0) 
				{
				TBuf <KBTDeviceAddress> address;
				iSMediator->GetAddress(address, itemIndex -1);
	
				// Display address using an information note
				CAknInformationNote* addressNote = 
				                    new (ELeave) CAknInformationNote;
				addressNote->ExecuteLD(address);
				}				
			}
		}
	
	}

// ----------------------------------------------------------------------------
// CDeviceListContainer::SetSMediator(CSharedIntermediator* aSMediator)
//
// Set a shared intermediator for this class.
// ----------------------------------------------------------------------------
void CDeviceListContainer::SetSMediator(CSharedIntermediator* aSMediator)
	{
	iSMediator = aSMediator;
	}


// ----------------------------------------------------------------------------
// CDeviceListContainer::ClearListBox()
//
// Clear listbox.
// ----------------------------------------------------------------------------
void CDeviceListContainer::ClearListBox()
	{
	CTextListBoxModel* model = iDeviceListBox->Model();
	CDesCArray* deviceArray = static_cast <CDesCArray*>(model->ItemTextArray());
	deviceArray->Reset();
	}

void CDeviceListContainer::HandleResourceChange(TInt aType)
    {
    CCoeControl::HandleResourceChange(aType);
    if ( aType==KEikDynamicLayoutVariantSwitch )
        {
        TRect rect;
        AknLayoutUtils::LayoutMetricsRect(AknLayoutUtils::EMainPane, rect);
        SetRect(rect);
        }
    }

