/*
 * Copyright  2008 Nokia Corporation.
 */


// INCLUDES
#include <e32base.h> 
#include "aknnotewrappers.h"
#include "DeviceListContainer.h"

// Listbox screen update interval
const TInt KSecond = 1000 * 1000;

#include "ListboxRefreshTimer.h"

// ----------------------------------------------------------------------------
// CListboxRefreshTimer::CListboxRefreshTimer()
//
// Constructor.
// ----------------------------------------------------------------------------
CListboxRefreshTimer::CListboxRefreshTimer(CDeviceListContainer* aListBox)
	: CTimer(CActive::EPriorityStandard), iListbox(aListBox) 
	{
	}

// ----------------------------------------------------------------------------
// CListboxRefreshTimer::~CListboxRefreshTimer()
//
// Destructor.
// ----------------------------------------------------------------------------
CListboxRefreshTimer::~CListboxRefreshTimer()
	{
	Cancel();
	}


CListboxRefreshTimer* CListboxRefreshTimer::NewL(
                                            CDeviceListContainer* aListBox )
	{
	CListboxRefreshTimer* self = CListboxRefreshTimer::NewLC(aListBox);
	CleanupStack::Pop(self);
	return self;
	}

CListboxRefreshTimer* CListboxRefreshTimer::NewLC(
                                           CDeviceListContainer* aListBox )
	{
	CListboxRefreshTimer* self = new (ELeave) CListboxRefreshTimer(aListBox);
	CleanupStack::PushL(self);
	
	self->ConstructL();
	return self;
	}

// Standard Symbian OS 2nd phase constructor
void CListboxRefreshTimer::ConstructL()
	{
	CTimer::ConstructL();
	CActiveScheduler::Add(this);
	}

// ----------------------------------------------------------------------------
// CListboxRefreshTimer::StartL()
//
// Start updating the listbox.
// ----------------------------------------------------------------------------
void CListboxRefreshTimer::StartL()
	{
	After( KSecond );	
	}

// ----------------------------------------------------------------------------
// CListboxRefreshTimer::RunL()
// ----------------------------------------------------------------------------
void CListboxRefreshTimer::RunL()
	{
	// Update the listbox.
	iListbox->HandleChangedL();
	// Wait for a while and run the same function again 
	After( KSecond );
	}

// ----------------------------------------------------------------------------
// CListboxRefreshTimer::DoCancel()
//
// Cancel and stop the timer. 
// ----------------------------------------------------------------------------
void CListboxRefreshTimer::DoCancel()	
	{
	CTimer::DoCancel();
	}

// ----------------------------------------------------------------------------
// CListboxRefreshTimer::RunError(TInt)
// ----------------------------------------------------------------------------
TInt CListboxRefreshTimer::RunError(TInt)
	{
	return KErrNone;
	}

