/*
 * Copyright  2008 Nokia Corporation.
 */


// INCLUDES
#include <avkon.hrh>
#include <aknnotewrappers.h> 
#include <ThreadAO.rsg>		// R_SET_REFRESH_TIME_DIALOG

#include <btnotifierapi.h>

#include "ThreadAO.pan"
#include "ThreadAOAppUi.h"
#include "ThreadAO.hrh"
#include "threadAOengine.h"
#include "DevicelistContainer.h"
#include "SharedIntermediator.h"
#include "BluetoothRefreshTimer.h"

#include "ListboxRefreshTimer.h"

// ----------------------------------------------------------------------------
// CThreadAOAppUi::ConstructL()
//
// Standard Symbian OS 2nd phase constructor. 
// ----------------------------------------------------------------------------
void CThreadAOAppUi::ConstructL()
    {
    BaseConstructL( CAknAppUi::EAknEnableSkin );

	// Create listbox container
    iContainer = CDeviceListContainer::NewL(ClientRect());
    iContainer->SetMopParent(this);

	// Add view to control stack
	AddToStackL(iContainer);
	iSMediator = CSharedIntermediator::NewL(iContainer);

	// Doesn't take ownership
	iContainer->SetSMediator(iSMediator);

	// Listbox refresh timer. Needed because calling HandleItemAdditionL
	// from thread1 doesn't seem to work.  
	iTimer = CListboxRefreshTimer::NewL( iContainer );

	// Start refreshing the the listbox.
	iTimer->StartL();

	// Create thread engine which creates thread1.
	iThreadEngine = CThreadAOEngine::NewL(iSMediator);
	}

TBool CThreadAOAppUi::TurnBtOnL()
    {
    RNotifier notifier;
    User::LeaveIfError( notifier.Connect() );
    TPckgBuf<TBool> dummy(ETrue);
    TPckgBuf<TBool> reply(ETrue);
    TRequestStatus stat;

    notifier.StartNotifierAndGetResponse(stat, KPowerModeSettingNotifierUid, dummy, reply);
    User::WaitForRequest(stat);

    notifier.CancelNotifier(KPowerModeSettingNotifierUid);
    notifier.Close();
    return reply();
    }


// ----------------------------------------------------------------------------
// CThreadAOAppUi::CThreadAOAppUi()  
//
// Constructor.
// ----------------------------------------------------------------------------
CThreadAOAppUi::CThreadAOAppUi() : iThreadStarted(EFalse)                          
    {
    }

// ----------------------------------------------------------------------------
// CThreadAOAppUi::~CThreadAOAppUi()
//
// Destructor.
// ----------------------------------------------------------------------------
CThreadAOAppUi::~CThreadAOAppUi()
    {
	delete iThreadEngine;

    if ( iContainer )
        {
        iEikonEnv->RemoveFromStack(iContainer);
        delete iContainer;
        }
	
	delete iTimer;

	delete iSMediator;
	}

// ----------------------------------------------------------------------------
// CThreadAOAppUi::HandleCommandL(TInt aCommand)
//
// Takes care of command handling.
// ----------------------------------------------------------------------------
void CThreadAOAppUi::HandleCommandL(TInt aCommand)
    {
    switch(aCommand)
        {
        case EEikCmdExit:
        case EAknSoftkeyExit:
			{
			if (iThreadStarted)
				{
				// CThreadListener is responsible for exiting the program.
				// The object is created in ThreadEngine CreateThreadsL().
				// This is done because thread1 needs to cleanup before killing
				// the thread.
				iThreadEngine->Stop();
				}
			else 
				{
				Exit();
				}
			}
            break;

		case EThreadStartCommand:
            {
            if (!TurnBtOnL())
                {
                return;
                }

			// start thread1 ( bluetooth discovery )
		    if (!iThreadStarted)
				{
				iThreadEngine->StartL();
				iThreadStarted = ETrue;
				}
            }
            break;
		
		case EThreadSetRefreshTimeCommand:
            {
			// Query a new refresh time and set the new value.
			if ( iThreadStarted )
				{
				TInt newRefreshTime = 0;
			    CAknNumberQueryDialog* dlg = new (ELeave) 
			   CAknNumberQueryDialog(newRefreshTime, CAknQueryDialog::ENoTone);
				if ( dlg->ExecuteLD( R_SET_REFRESH_TIME_DIALOG ) )
					{
					iSMediator->BTRefreshTimerPtr()->SetRefreshTime(
					                                          newRefreshTime );
					}
				}
			else 
				// If threadOne hasn't been started, query a new refresh time
				// and set refresh timer's initial value.
				{
				TInt newRefreshTime = 0;
			    CAknNumberQueryDialog* dlg = new (ELeave) 
			   CAknNumberQueryDialog(newRefreshTime, CAknQueryDialog::ENoTone);
				if (dlg->ExecuteLD(R_SET_REFRESH_TIME_DIALOG))
					{
					iSMediator->SetRefreshTimerInitlVal( newRefreshTime );
					}
				}
            }
            break;

        default:
            Panic(EThreadUi);
            break;
        }
    }

// ---------------------------------------------------------
// CThreadAOAppUi::HandleStatusPaneSizeChange()
// Called by framework when resource is changed.
// ---------------------------------------------------------
//
void CThreadAOAppUi::HandleStatusPaneSizeChange()
	{
	CAknAppUi::HandleStatusPaneSizeChange(); //call to upper class
	iContainer->SetRect( ClientRect());
	}


