/*
 * Copyright  2008 Nokia Corporation.
 */


// INCLUDES
#include "ThreadAOAppUi.h"
#include "ThreadAODocument.h"

CThreadAODocument* CThreadAODocument::NewL(CEikApplication& aApp)
    {
    CThreadAODocument* self = NewLC(aApp);
    CleanupStack::Pop(self);
    return self;
    }

CThreadAODocument* CThreadAODocument::NewLC(CEikApplication& aApp)
    {
    CThreadAODocument* self = new (ELeave) CThreadAODocument(aApp);
    CleanupStack::PushL(self);
    self->ConstructL();
    return self;
    }

// ----------------------------------------------------------------------------
// CThreadAODocument::ConstructL()
//
// Standard Symbian OS 2nd phase constructor
// ----------------------------------------------------------------------------
void CThreadAODocument::ConstructL()
    {
	// No implementation required
    }    

// ----------------------------------------------------------------------------
// CThreadAODocument::CThreadAODocument(CEikApplication& aApp) 
//   
// Constructor.
// ----------------------------------------------------------------------------
CThreadAODocument::CThreadAODocument(  CEikApplication& aApp) : 
	CAknDocument( aApp ) 
    {
    }

// ----------------------------------------------------------------------------
// CThreadAODocument::~CThreadAODocument()
//   
// Destructor.
// ----------------------------------------------------------------------------
CThreadAODocument::~CThreadAODocument()
    {
    }

// ----------------------------------------------------------------------------
// CThreadAODocument::CreateAppUiL()
//
// Constructs CThreadAOAppUi.
// ----------------------------------------------------------------------------
CEikAppUi* CThreadAODocument::CreateAppUiL()
    {
    // Create the application user interface, and return a pointer to it;
    // the framework takes ownership of this object
	return (static_cast <CEikAppUi*> (new (ELeave) CThreadAOAppUi)); 
    }

