/*
 * Copyright  2008 Nokia Corporation.
 */


// INCLUDES
#include <e32base.h> 
#include <aknnotewrappers.h>

#include "..\inc\threadaoengine.h"
#include "SharedIntermediator.h"
#include "BluetoothRefreshTimer.h"
#include "Devicelistcontainer.h"

// CONSTANTS
_LIT( KThreadOneName, "thread1" );
const TInt KStackSize = 4096;

// ----------------------------------------------------------------------------
// CThreadAOEngine::CThreadAOEngine(CSharedIntermediator* aSMediator)
//
// Constructor.
// ----------------------------------------------------------------------------
CThreadAOEngine::CThreadAOEngine( CSharedIntermediator* aSMediator ) :
    iCreatedThreads(EFalse), 
    iSMediator(aSMediator), iListener(0)
	{
	}

// ----------------------------------------------------------------------------
// CThreadAOEngine::~CThreadAOEngine()
//
// Destructor.
// ----------------------------------------------------------------------------
CThreadAOEngine::~CThreadAOEngine()
	{
    // Thread should be killed allready, if thread is already killed this does
    // nothing
	iThreadOne.Kill(KErrNone);
	// Handles should be closed
	iThreadOne.Close();

	delete iListener;
	}

CThreadAOEngine* CThreadAOEngine::NewL(CSharedIntermediator* aSMediator)
	{
	CThreadAOEngine* self = CThreadAOEngine::NewLC(aSMediator);
	CleanupStack::Pop(self);
	return self;
	}

CThreadAOEngine* CThreadAOEngine::NewLC(CSharedIntermediator* aSMediator)
	{
	CThreadAOEngine* self = new (ELeave) CThreadAOEngine(aSMediator);
	CleanupStack::PushL(self);
	self->ConstructL();
	return self;
	}

// Standard Symbian OS 2nd phase constructor
void CThreadAOEngine::ConstructL()
	{
	}

// ----------------------------------------------------------------------------
// CThreadAOEngine::StartL()
//
// Create a new thread (= thread1).
// ----------------------------------------------------------------------------
void CThreadAOEngine::StartL()
	{
	
	// Create threads only once
	if ( iCreatedThreads == false )
		{
		CreateThreadsL();
		}
	}

// ----------------------------------------------------------------------------
// CThreadAOEngine::Stop()
//
// Stop thread1. Stop thread1 ActiveScheduler.
// ----------------------------------------------------------------------------
void CThreadAOEngine::Stop()
	{
	// Notify that the BT search should be cancelled.
	iSMediator->SetStopSearching(ETrue);
	}

// ----------------------------------------------------------------------------
// CThreadAOEngine::ExecuteThread(TAny *aPtr)
//
// Threadfunction of threadOne. Executed only by threadOne.
// ----------------------------------------------------------------------------
TInt CThreadAOEngine::ExecuteThreadOne(TAny *aPtr)
	{
	CSharedIntermediator* sharedMediator = 
                             static_cast<CSharedIntermediator*>( aPtr );
	
	// Create cleanupstack	
	CTrapCleanup* cleanupStack = CTrapCleanup::New();

	// Test cleanup stack, additional cleanup stack must be prosessed under TRAP
	// We can't use low level cleanup stack handling
	TRAPD( error, CThreadAOEngine::CreateActiveSchedulerL( sharedMediator ) )

	delete cleanupStack;
	
	return 0;
	}


// ----------------------------------------------------------------------------
// CThreadAOEngine::CreateActiveScheduler(CSharedIntermediator* aSMediator)
//
// Create ActiveScheduler for thread1.
// ----------------------------------------------------------------------------
void CThreadAOEngine::CreateActiveSchedulerL(CSharedIntermediator* aSMediator)
	{
	// create a new active scheduler
	CActiveScheduler* activeScheduler = new (ELeave) CActiveScheduler;
	CleanupStack::PushL(activeScheduler);

	// use static function Install to install previously created scheduler
	CActiveScheduler::Install(activeScheduler);

	CActiveSchedulerWait* wait = new (ELeave) CActiveSchedulerWait;
	CleanupStack::PushL(wait);
	
	CBluetoothRefreshTimer* timer = CBluetoothRefreshTimer::NewL(
                                                         aSMediator, wait );
	CleanupStack::PushL(timer);

	CActiveScheduler::Add(timer);

	// Scheduler must have one outstanding request before it can be started.
	timer->StartL();
	wait->Start();	

    // Remove and delete scheduler and the rest.
	CleanupStack::PopAndDestroy(3);
	}


// ----------------------------------------------------------------------------
// CThreadAOEngine::CreateThreadsL()
//
// Create thread1 and resume it. Activate thread1 listener.
// ----------------------------------------------------------------------------
void CThreadAOEngine::CreateThreadsL()
	{
	// Create thread which uses the same heap as main program.
	iThreadOne.Create( KThreadOneName, ExecuteThreadOne, KStackSize, NULL, iSMediator);
	iThreadOne.Resume();
	
	// Listen to thread1 state. 
	iListener = CThreadListener::NewL(iThreadOne);

	iCreatedThreads = ETrue;
	}

