/*
 * Copyright  2008 Nokia Corporation.
 */


#include "ThreadListener.h"

CThreadListener* CThreadListener::NewL(RThread& aThread)
    {
    CThreadListener* self = CThreadListener::NewLC(aThread);
    CleanupStack::Pop(self);
    return self;
    }

CThreadListener* CThreadListener::NewLC(RThread& aThread)
    {
    CThreadListener* self = new (ELeave) CThreadListener();
    CleanupStack::PushL(self);
    self->ConstructL(aThread);
    return self;
    }

// ----------------------------------------------------------------------------
// CThreadListener::CThreadListener()
//
// Constructor.
// ----------------------------------------------------------------------------
CThreadListener::CThreadListener(): 
	CActive(EPriorityStandard)
	{
	}

// ----------------------------------------------------------------------------
// CThreadListener::CThreadListener()
//
// Destructor.
// ----------------------------------------------------------------------------
CThreadListener::~CThreadListener()
	{
	Cancel();
	iMonitoredThread.Close();
	}

// Standard Symbian OS 2nd phase constructor
void CThreadListener::ConstructL(RThread& aThread)
    {
	CActiveScheduler::Add(this);
	User::LeaveIfError( iMonitoredThread.Open(aThread.Id()) );
	iMonitoredThread.Logon(iStatus);
	SetActive();
    }


// ----------------------------------------------------------------------------
// CThreadListener::RunL()
//
// iStatus is given to ThreadOne Logon( ). 
// Logon requests notification when thread1 dies, normally or otherwise.
// ----------------------------------------------------------------------------
 void CThreadListener::RunL()
	{
	// Only in this example:
	// Consider any completion value as an error - exit now
	User::Exit(0);
	}

// ----------------------------------------------------------------------------
// CThreadListener::DoCancel()
// ----------------------------------------------------------------------------
 void CThreadListener::DoCancel()
	{
	iMonitoredThread.LogonCancel(iStatus);
	}
