/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef CONTACTSMODELAPPUI_H
#define CONTACTSMODELAPPUI_H

// INCLUDES
#include <eikapp.h>
#include <eikdoc.h>
#include <e32std.h>
#include <coeccntx.h>
#include <aknappui.h>

// FORWARD DECLARATIONS
class CContactsModelContainer;


// CLASS DECLARATION

/**
* Application UI class.
* Provides support for the following features:
* - EIKON control architecture
*
*/
class CContactsModelAppUi : public CAknAppUi
    {
    public: // // Constructors and destructor

        /**
        * EPOC default constructor.
        */
        void ConstructL();

        /**
        * Destructor.
        */
        ~CContactsModelAppUi();

    public: // New functions

    public: // Functions from base classes

    private:
        // From MEikMenuObserver
        void DynInitMenuPaneL(TInt aResourceId, CEikMenuPane* aMenuPane);

    private:
        /**
        * From CEikAppUi, takes care of command handling.
        * @param aCommand command to be handled
        */
        void HandleCommandL(TInt aCommand);

        /**
        * From CEikAppUi, takes care of updating from model.
        */
		void HandleModelChangeL();

		/**
     	 * HandleResourceChange.
     	 * Called by framework when the view layout is changed.
     	 */

    	void HandleResourceChangeL(TInt aType);

        /**
        * From CEikAppUi, handles key events.
        * @param aKeyEvent Event to handled.
        * @param aType Type of the key event.
        * @return Response code (EKeyWasConsumed, EKeyWasNotConsumed).
        */
        virtual TKeyResponse HandleKeyEventL(
            const TKeyEvent& aKeyEvent,TEventCode aType);

		/**
		* ImportL
		*
		*   Opens the specified file and calls corresponding function
		*   from CContacIEDocument to import vCards from there.
		*
		* Parameters
		*	aFileName - full path and filename of the file for import
		*
		* Returns
		*	Nothing
		**/
		void ImportL(const TDesC& aFileName);

		/**
		* ExportL
		*
		*   Creates the specified file and calls corresponding function
		*   from CContacIEDocument to export a selected item.
		*
		* Parameters
		*	aFileName - full path and filename of the file for import
		*
		* Returns
		*	Nothing
		**/
		void ExportL(const TDesC& aFileName, TInt aItemIndex);

    private: //Data
        CContactsModelContainer* iAppContainer;
    };

#endif

// End of File
