/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef CONTACTSMODELCONTAINER_H
#define CONTACTSMODELCONTAINER_H

// INCLUDES
#include <aknlists.h>
#include <coecntrl.h>

// FORWARD DECLARATIONS
class CContactsModelDocument;

// CLASS DECLARATION

/**
*  CContactsModelContainer  container control class.
*
*/
class CContactsModelContainer : public CCoeControl, MCoeControlObserver
    {
    public: // Constructors and destructor

        /**
        * EPOC default constructor.
        * @param aRect Frame rectangle for container.
        */
        void ConstructL(const TRect& aRect, CContactsModelDocument* aDocument);

        /**
        * Destructor.
        */
        ~CContactsModelContainer();

    public: // New functions

       /**
        * Updates list view from the document.
        */
		void UpdateL();

       /**
        * Returns selected item from the listbox.
        */
		TInt GetSelectedItem();

	   /**
		* ItemCount
		*
		*   Return the number of contact items in the default database
		*
		* Returns
		*	Number of contact items
		**/
		TInt ItemCount();

    public: // Functions from base classes

    private: // Functions from base classes

       /**
        * From CoeControl,SizeChanged.
        */
        void SizeChanged();

       /**
        * From CoeControl,CountComponentControls.
        */
        TInt CountComponentControls() const;

       /**
        * From CCoeControl,ComponentControl.
        */
        CCoeControl* ComponentControl(TInt aIndex) const;

       /**
        * From CCoeControl,Draw.
        */
        void Draw(const TRect& aRect) const;


		/**
		* From MCoeControlObserver
		* Acts upon changes in the hosted control's state.
		*
		* @param	aControl	The control changing its state
		* @param	aEventType	The type of control event
		*/
        void HandleControlEventL(CCoeControl* aControl,TCoeEvent aEventType);

		/*!
		* OfferKeyEventL
		*
		*	@param aKeyEvent The key event.
		*	@param aType The type of key event: EEventKey, EEventKeyUp or EEventKeyDown.
		*
		*	@result Was the key event used by this control.
		*/
		TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent, TEventCode aType);

    private: //data

		//reference to the document
		CContactsModelDocument* iDocument;

		//list box component
	    CAknSingleStyleListBox* iListBox;

		//list box data
		CDesCArrayFlat* iListBoxRows;
    };

#endif

// End of File
