/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef CONTACTSMODELDOCUMENT_H
#define CONTACTSMODELDOCUMENT_H

// INCLUDES
#include <akndoc.h>

#include <cntdb.h>

// CONSTANTS

// FORWARD DECLARATIONS
class  CEikAppUi;

// CLASS DECLARATION

/**
*  CContactsModelDocument application class.
*/
class CContactsModelDocument : public CAknDocument
    {
    public: // Constructors and destructor
        /**
        * Two-phased constructor.
        */
        static CContactsModelDocument* NewL(CEikApplication& aApp);

        /**
        * Destructor.
        */
        virtual ~CContactsModelDocument();

    public: // New functions
		/**
		* GetItemL
		*
		*   Returns text representation of the specified contact item.
		*
		* Parameters
		*	anIndex - contact item index
		*
		* Returns
		*	String with the text description of the contact item
		**/
		HBufC * GetItemL(TInt anIndex);

		/**
		* ItemCount
		*
		*   Return the number of contact items in the default database
		*
		* Returns
		*	Number of contact items
		**/
		TInt ItemCount();

		/**
		* UpdateContactsL
		*
		*   Retrives the list of contact item ids from the default database.
		**/
		void UpdateContactsL();

		/**
		* ImportL
		*
		*   Reads from the stream vCard and tries
		*   to import them in the default database.
		*
		* Parameters
		*	aReadStream - read stream with vCards
		*
		* Returns
		*	KErrNone or KErrGeneral if import failed
		**/
		TInt ImportL(RReadStream& aReadStream);

		/**
		* ExportL
		*
		*   Exports the selected item from the default contact database
		*	to the specified ouput stream as vCard.
		*
		* Parameters
		*	aWriteStream - output stream to write the item as vCard
		*   aExportItem - the index of item for export
		*
		* Returns
		*	Nothing
		**/
		void ExportL(RWriteStream& aWriteStream, TInt aExportItem);


    private:

        /**
        * EPOC default constructor.
        */
        CContactsModelDocument(CEikApplication& aApp);
        void ConstructL();

    private:

        /**
        * From CEikDocument, create CContactsModelAppUi "App UI" object.
        */
        CEikAppUi* CreateAppUiL();

		// array of contact's ids that are displayed in the application
		CContactIdArray* iContacts;

		//text definition used to display contact items
		CContactTextDef* iTextDef;
    };

#endif

// End of File

