/*
 * Copyright  2008 Nokia Corporation.
 */

// INCLUDE FILES
#include <eikstart.h>
#include "ContactsModelApp.h"
#include "ContactsModelDocument.h"

// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------
// CContactsModelApp::AppDllUid()
// Returns application UID
// ---------------------------------------------------------
//
TUid CContactsModelApp::AppDllUid() const
    {
    return KUidContactsModel;
    }

// ---------------------------------------------------------
// CContactsModelApp::CreateDocumentL()
// Creates CContactsModelDocument object
// ---------------------------------------------------------
//
CApaDocument* CContactsModelApp::CreateDocumentL()
    {
    return CContactsModelDocument::NewL( *this );
    }

// ================= OTHER EXPORTED FUNCTIONS ==============
//
// ---------------------------------------------------------
// NewApplication()
// Constructs CContactsModelApp
// Returns: created application object
// ---------------------------------------------------------
//
EXPORT_C CApaApplication* NewApplication()
    {
    return new CContactsModelApp;
    }

// ---------------------------------------------------------
// E32Main()
// Entry point function for new (>= 9.0) EPOC Apps (exe)
// Returns: Sistem Wide error codes or KErrNone if all goes well
// ---------------------------------------------------------
//
GLDEF_C TInt E32Main()
{
	return EikStart::RunApplication( NewApplication );
}
// End of File

