/*
 * Copyright  2008 Nokia Corporation.
 */

// INCLUDE FILES
#include "ContactsModelDocument.h"
#include "ContactsModelContainer.h"

const TInt KGranularityOfArray = 10;

const TInt KBufferSize = 256;
// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------
// CContactsModelContainer::ConstructL(const TRect& aRect)
// EPOC two phased constructor
// ---------------------------------------------------------
//
void CContactsModelContainer::ConstructL(const TRect& aRect, CContactsModelDocument* aDocument)
    {
	iDocument = aDocument;
    CreateWindowL();
    SetRect(aRect);

	// create listbox control
    iListBox = new (ELeave) CAknSingleStyleListBox;
    iListBox->ConstructL(this, 0);
	iListBox->SetContainerWindowL(*this);
    iListBox->SetRect(aRect.Size());

	iListBoxRows = new (ELeave) CDesCArrayFlat( KGranularityOfArray );
	iListBox->Model()->SetItemTextArray( iListBoxRows );
	iListBox->Model()->SetOwnershipType(ELbmDoesNotOwnItemArray);

    iListBox->ActivateL();
    iListBox->CreateScrollBarFrameL(ETrue);
    iListBox->ScrollBarFrame()->SetScrollBarVisibilityL(CEikScrollBarFrame::EOn,
    	CEikScrollBarFrame::EAuto);

    ActivateL();
	MakeVisible(ETrue);
    }

// Destructor
CContactsModelContainer::~CContactsModelContainer()
    {
	delete iListBox;
	iListBox = NULL;

	if( iListBoxRows )
		{
		iListBoxRows->Reset();
		}
	delete iListBoxRows;
	iListBoxRows= NULL;
    }

// ---------------------------------------------------------
// CContactsModelContainer::SizeChanged()
// Called by framework when the view size is changed
// ---------------------------------------------------------
//
void CContactsModelContainer::SizeChanged()
    {
    }

// ---------------------------------------------------------
// CContactsModelContainer::CountComponentControls() const
// ---------------------------------------------------------
//
TInt CContactsModelContainer::CountComponentControls() const
    {
    return 1; // return nbr of controls inside this container
    }

// ---------------------------------------------------------
// CContactsModelContainer::ComponentControl(TInt aIndex) const
// ---------------------------------------------------------
//
CCoeControl* CContactsModelContainer::ComponentControl(TInt aIndex) const
    {
	if( aIndex > 0 )
		{
		return NULL;
		}
    return iListBox;
    }

// ---------------------------------------------------------
// CContactsModelContainer::Draw(const TRect& aRect) const
// ---------------------------------------------------------
//
void CContactsModelContainer::Draw(const TRect& /*aRect*/) const
    {
    CWindowGc& gc = SystemGc();
    TRect rect = Rect();
    gc.Clear(rect);
    }

// ---------------------------------------------------------
// CContactsModelContainer::HandleControlEventL(
//     CCoeControl* aControl,TCoeEvent aEventType)
// ---------------------------------------------------------
//
void CContactsModelContainer::HandleControlEventL(
    CCoeControl* /*aControl*/,TCoeEvent /*aEventType*/)
    {
    // TODO: Add your control event handler code here
    }

void CContactsModelContainer::UpdateL()
    {
	iListBoxRows->Reset();
	if( iDocument->ItemCount() > 0 )
		{
		//add items to the list box
		for( TInt i = 0; i < iDocument->ItemCount(); ++i )
			{

			HBufC* row = iDocument->GetItemL(i);
			CleanupStack::PushL(row);

			TBuf<KBufferSize> buf;
			buf.Format(_L("\t%S"), row);
			iListBoxRows->AppendL(buf);

			CleanupStack::PopAndDestroy();
			}
		//update the control
		iListBox->HandleItemAdditionL();
		}
	}

// return contacts items number
TInt CContactsModelContainer::ItemCount()
{
	return iDocument->ItemCount();
}

TKeyResponse CContactsModelContainer::OfferKeyEventL(const TKeyEvent& aKeyEvent, TEventCode aType)
    {
    return iListBox->OfferKeyEventL(aKeyEvent, aType);
    }

TInt CContactsModelContainer::GetSelectedItem()
	{
	return iListBox->CurrentItemIndex();
	}

// End of File
