// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the definition of the CContainer class.
//



/**
 @file 
*/
#ifndef __CONSUMER_H__
#define __CONSUMER_H__

#include "globals.h"
#include "queue.h"

/**
This class owns the consumer thread.
It provides an interface to remove tokens from the CQueue::iArray queue.
@see CQueue.
@see CPeriodic.
*/
class CConsumer : public CBase
	{
public:
	static CConsumer* NewL(CConsoleBase* aConsole,CQueue* aTokens);
	void ConstructL(CConsoleBase* aConsole,CQueue* aTokens);
	static TInt ConsThreadFunc(TAny* aPtr);
	void ResumeCons();
	void Consume();
	~CConsumer();
	static TInt RemoveFunction(TAny* aPtr);
private:
	CConsumer();
private:
	/**
	The pointer to a CQueue object.
	Both CProducer and the CConsumer classes share the same object of the CQueue class.
	@see CProducer::iQueue.
	*/
	CQueue* iQueue;
	/**
	The consumer thread.
	It is invoked periodically by the CConsumer::iPeriodicCons object, which is an instance of the CPeriodic class.
	*/
	RThread iConsThread;
	/**
	The CPeriodic object.
	It runs the consumer thread (CConsumer::iConstThread) at regular intervals.
	@see CConsumer::ConstructL().
	*/
	CPeriodic* iPeriodicCons;
	/**
	The user console.
	*/
	CConsoleBase* iConsole;
	};

#endif
