// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the definition of the CQueue class.
//



/**
 @file 
*/
#ifndef __QUEUE_H__
#define __QUEUE_H__

#include "globals.h"

/**
A wrapper class that implements the queue of integer tokens.
It owns a handle to an integer array. This array is treated as a queue of tokens.
It provides functions to insert, delete and display elements in the queue.
It also owns a  handle to the condition variable and a mutex variable.
@see RCondVar.
@see RMutex.
*/
class CQueue : public CBase
	{
public:
	void Insert();
	void Remove();
	TBool IsEmpty();
	void ConstructL();
	static CQueue* NewL();
	void GetTokens(RArray<TInt>& aArray);
	~CQueue();
private:
	CQueue();
private:
	/**
	The integer array that represents the queue.
	*/
	RArray<TInt> iArray;
	/**
	The mutex variable.
	*/
	RMutex iMutex;
	/**
	The local condition variable.
	*/
	RCondVar iCondVar;
	};

#endif
