// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the definition of member functions of the CUserInterface class.
//



/**
 @file 
*/

#include "userinterface.h"

/**
The static function to create an object of the CUserInterface class.
@param aConsole The console object.
@param aProducer A pointer to an object of the CProducer class.
@param aConsumer A pointer to an object of the CConsumer class.
@return A CUserInterface object.
*/
CUserInterface* CUserInterface::NewL(CConsoleBase* aConsole,CProducer* aProducer)
	{
	CUserInterface* self = new (ELeave)CUserInterface;
	self->Initialize(aConsole,aProducer);
	return self;
	}

/**
Initialize the data members of the CUserInterface class.
@param aConsole The console object.
@param aProducer A pointer to an object of the CProducer class.
@param aConsumer A pointer to an object of the CConsumer class.
*/
void CUserInterface::Initialize(CConsoleBase* aConsole,CProducer* aProducer)
	{
	iConsole = aConsole;
	iProducer = aProducer;
	CActiveScheduler::Add(this);
	}

/**
Constructor.
*/
CUserInterface::CUserInterface():CActive(CActive::EPriorityUserInput)
	{
	}

/**
Handles the key press events from the console.
The following actions are defined for a key press event:
- Call the CPRoducer::Produce() function if 'p' is pressed
- Call the CPRoducer::Display() function if 'd' is pressed
- Stop the active scheduler if any other key is pressed
*/
void CUserInterface::RunL()
	{
	// Get the key code.
	TUint8 option = iConsole->KeyCode();
	// Print the selected option.
	_LIT(KTextFormat,"%c\n");
	iConsole->Printf(KTextFormat,option);
	switch(option)
		{
		case 'p':
			{
			// If the user input is 'p', insert tokens into the CUserInterface::iQueue queue.
			iProducer->Produce();
			ReadFunc();
			}
			break;
		case 'd':
			{
			// If the user input is 'd', display the contents of the CUserInterface::iQueue queue.
			iProducer->Display();
			ReadFunc();
			}
			break;
		default:
			{
			// Stop the active scheduler for other user inputs.
			CActiveScheduler::Stop();
			}
		}
	}

/**
Issues an outstanding request to get a keystroke from the console.
*/
void CUserInterface::ReadFunc()
	{
	// Print the menu.
	_LIT(KTxtOption,"***\nMenu:\n[p]roduce a token\n[d]isplay the contents of the queue\nAny other key to stop\n***\n");
	iConsole->Printf(KTxtOption);
	// Wait for a key press event.
	iConsole->Read(iStatus);
	SetActive();
	}

/**
Cancel any outstanding request.
*/
void CUserInterface::DoCancel()
	{
	if(IsActive())
		{
		// Cancel any outstanding read requests.
		iConsole->ReadCancel();
		}
	}

/**
Destructor.
*/
CUserInterface::~CUserInterface()
	{
	DoCancel();
	}
