// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef FEATURECHECKER_H_
#define FEATURECHECKER_H_
#include <featmgr/featurenotifier.h>
#include <featmgr/featurecmn.h>
#include <e32base.h>

/**
This class implements the MFeatureObserver interface methods to receive notification of changes to features.
*/
class CFeatureChecker : public CBase, public MFeatureObserver 
{
public:
	static CFeatureChecker* NewL();
	virtual ~CFeatureChecker();
	virtual void HandleNotifyChange(TFeatureChangeType aType, TFeatureEntry aFeature);
	virtual void HandleNotifyError(TInt aError);
	void NotifyFeatureL();
protected:
	void ConstructL();
	
private:
	CFeatureNotifier* iFeatNotifier;
};

#endif /*FEATURECHECKER_H_*/

