// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//


#ifndef __FEATMNGREXAMPLE_H__
#define __FEATMNGREXAMPLE_H__

#include <e32base.h>
#include <e32cons.h>
#include <featmgr/featmgr.h>
#include <featmgr/featurecontrol.h>


/**
Demonstrates how to use the RFeatureControl class to add, delete, update and modify features.

This class presents the main menu to the user. Depending on the user's input, it performs various 
feature-related operations. It also creates and runs the FeatureChecker process so that any changes
to features made in this process receive corresponding notification.
*/
class CFeatMngrExample: public CActive
{
public:
	static CFeatMngrExample* NewL(TInt aPriority = EPriorityStandard);
	virtual ~CFeatMngrExample();
	void RequestCharacter();
	void ProcessKeyPressL(TChar);
	virtual void DoCancel();
	virtual void RunL();
	void AddL();
	void DeleteL();
	void UpdateL();
	void ListFeaturesL();
	void CheckFeatureSupportL();
	void EnableFeatureL();
	TInt64 GetUserInput(TBool aDecimal);
	
protected:
	void ConstructL();
	
private:	
	CFeatMngrExample(TInt aPriority = EPriorityStandard );
	CConsoleBase* iConsole;
	RFeatureControl iFeatControl;
	RProcess iProcess;
};
#endif  // __FEATMNGREXAMPLE_H__

