// Copyright (c) 2006-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// main_serv_app.cpp
//

#include <e32base.h>

#include "client_api.h"
#include "session.h"

const TUid KAppUid = { 0xE1111556 };

static void callExampleL();

extern TInt  E32Main()
    {
	__UHEAP_MARK;
	CTrapCleanup* cleanup=CTrapCleanup::New();

	TRAPD(error,callExampleL());
	_LIT(KTxtTrainingTest,"TrainingApp");	
	__ASSERT_ALWAYS(!error,User::Panic(KTxtTrainingTest,error));
	delete cleanup;
	__UHEAP_MARKEND; // Check the test program doesn't leak memory.
	return KErrNone;
	}
	
static void callExampleL()
    {
    RServAppService exampleSess;
    
    _LIT(KHelloWorld,"Hello World!");
    
    TBufC<12> exampleBuf(KHelloWorld);
    
  	exampleSess.ConnectNewAppL(KAppUid);
    exampleSess.Send(exampleBuf);
    exampleSess.Close();
    }
