/** @file redirectprintf.c
 * Contained the implementation of how to redirect stdout into a file.
 */
/*
* ==============================================================================
*  Name        : redirectprintf.c
*  Part of     : Open C/Example code
*  Description : Contained the implementation of how to redirect stdout into a file.
*  Version     : 1.0
*
*  Copyright (c) 2007 Nokia Corporation.
*  This material, including documentation and any related
*  computer programs, is protected by copyright controlled by
*  Nokia Corporation.
* ==============================================================================
*/

// system include
#include <stdio.h>
// GCCE specific header file
//#include <staticlibinit_gcce.h>


// Debug message
FILE* fpDebug = NULL;
char* logFileName = "c:\\logs\\trace.txt";
const char* anotherLogFile = "c:\\logs\\newlog.txt";

/**
* Use to redirect the printf statements
* @param aMessagePtr pointer to the message
* @param ... Variable parameters like printf
*
*/
int RedirectPrintf(char* aMessagePtr, ...)
{
    va_list marker;
    int printChar;
    if(fpDebug == NULL)
    {
        fpDebug = freopen(logFileName, "a+", stdout);
    }
    if(fpDebug != NULL)
    {
        va_start(marker, aMessagePtr);
        printChar = vprintf(aMessagePtr, marker);
        va_end(marker);
    }
    return printChar;
}

/**
* application entry point
*/

int main(void)
{
	int printInt = 10;
    // this will print in console
    printf("Redirecting printf to - %s\n", logFileName);
    // from this statement onwards, printf statement will be redirected to file
    printf("You wnt be able to see the message within the \nconsole.\n");
    // put this message first. Once RedirectPrintf statement is called, printf statement will be redirect to file.
    printf("Press enter to exit.");
    RedirectPrintf("Printing something using trace.\n");
    if(fpDebug != NULL)
    {
        printf("printing using printf method.\n");
        printf("Printing an integer - %d.\n", printInt);

        printf("Redirecting printf to another file - %s\n", anotherLogFile);
    	fpDebug = freopen(anotherLogFile, "a+", fpDebug);
        if(fpDebug != NULL)
        {
            printf("Start redirecting printf to - %s\n", anotherLogFile);
            printf("Closing the printf stream.\n");
            fclose(fpDebug);
        }
    }
    fflush(stdin);
    getchar(); // wait for user input before terminate
    return 0;
}


//End of file
