// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Contains the declaration of all constants and the security policy of the property
//



/**
 @file
*/
#ifndef __PUBSUB_H__
#define __PUBSUB_H__

#include <e32base.h>
#include <e32cons.h>
#include <e32property.h>

const TUint KMyPropertyName = 0x0003;
const TUid KMyPropertyCat = {0x10034567};

const TInt KArraySize = 10;
const TInt KBufSize = 20;
_LIT16(KStop,"STOP");

const TInt KMax = 100;
const TInt KTimeInterval = 3000000;

_LIT(KTxtEnter,"Press enter to publish\n");
_LIT(KTxtNewLine,"\n");
_LIT(KTxtSpecPublish,"****        PUBLISH [SPECULATIVE]        ****\n\n");
_LIT(KTxtCreateHandle,"Creating a handle to the property...\n");
_LIT(KTxtPublish,"Publishing the byte-array property...\n");
_LIT(KTxtArray,"Array contents:\n");
_LIT(KTxtArrayElement,"%x\t");
_LIT(KTxtNotFound,"Property Not Found\n");
_LIT(KTxtSpecSub,"*** SUBSCRIBER [SPECULATIVE]        ***\n");
_LIT(KTxtSpecSt,"*** SUBSCRIBER [STANDARD STATE]        ***\n");
_LIT(KTxtStPublish,"****        PUBLISH [STANDARD STATE]        ****\n\n");
_LIT(KTxtDefine,"Defining a byte-array property and allocating memory for the same...\n");
_LIT(KTxtValChange,"Value of the property : %d\n");
_LIT(KTxtPESub,"*** SUBSCRIBER [PURE EVENT] ***\n");
_LIT(KTxtPEPublish,"*** PUBLISHER [PURE EVENT] ***\n");
_LIT(KTxtInt,"Publishing : %d\n");


_LIT(KTxtEPOC32EX,"Project::Publish and Subscribe");
_LIT(KTxtExampleCode,"Publish and Subscribe Example");
_LIT(KFormatFailed,"failed: leave code=%d");
_LIT(KTxtOK,"ok");
_LIT(KTxtPressAnyKey," [press any key]");

static _LIT_SECURITY_POLICY_PASS(KAllowAllPolicy);

_LIT(KTextConsoleTitle, "Console");
_LIT(KTextFailed, " failed, leave code = %d");
_LIT(KTextPressAnyKey, " [press any key]\n");

#endif
