/*
* ============================================================================
*  Name     : TRequest from Request.h
*  Part of  : TaskManager
*  Created  : 15/03/2006 by Forum Nokia
*  Version  : 1.2
*  Copyright: Nokia Corporation
* ============================================================================
*/

#ifndef __CREQUEST_H
#define __CREQUEST_H

// INCLUDE FILES
#include "TaskManager.hrh"

#include <e32std.h>

// CLASS DECLARATION

/**
* A parser class for handling requests to the server.
*/
class TRequest
	{
public:
    /**
    * Determines which operation is in question.
    */
   	enum TOperationType
   		{
   		EFetchTasks = 1,
   		ETaskDone
   		};

    /**
    * Function returns a valid message descriptor via reference parameter.
    * @param aUsername Client's username.
    * @param aPassword Client's password.
    * @param aOperation Type of operation.
    * @param aId Id of the task to be completed.
    * @param aMessage The descriptor to which the message is saved.
    */
	static void GetMessage( TDesC& aUsername, TDesC& aPassword,
	                        TRequest::TOperationType aOperation,
	                        TDesC& aId, TDes8& aMessage );

	};

#endif

// End of file




