/*
* ============================================================================
*  Name     : CTaskManagerAppUi from TaskManagerAppUi.h
*  Part of  : TaskManager
*  Created  : 15/03/2006 by Forum Nokia
*  Description:
*     Declares UI class for application.
*  Version  : 1.2
*  Copyright: Nokia Corporation
* ============================================================================
*/

#ifndef __TASKMANAGER_APPUI_H__
#define __TASKMANAGER_APPUI_H__

// INCLUDE FILES
#include "TaskManagerConnInfo.h"

#include <aknappui.h>

// FORWARD DECLARATIONS
class CTaskManagerAppView;
class CTaskManagerEngine;

// CLASS DECLARATION

/**
* Application UI class.
* Provides support for the following features:
* - EIKON control architecture
* 
*/
class CTaskManagerAppUi : public CAknAppUi
	{
public: // Constructors and destructor

    /**
    * Symbian OS default constructor.
    */      
	void ConstructL();

    /**
    * Destructor.
    */      
	~CTaskManagerAppUi();
	
public: // New functions

	/**
	* Returns reference to engine, which handles transactions.
	* @return Reference to engine.
	*/
	CTaskManagerEngine& Model();
	
	/**
	* Shows proper cba buttons according to the given boolean.
	* @param aShow defines whether only a cancel button (ETrue) or options and exit buttons are shown.
	*/
	void ShowConnectingCbaL(const TBool& aShow);	
	
	/**
	* AppView can inform the AppUi that it is busy doing something (like showing a query dialog).
	* While AppView is busy, AppUi makes sure that engine won't update tasks automatically.
	* @param aBusy defines whether the view is busy or not.
	*/
	void SetViewBusyL(const TBool& aBusy);


public: // Functions from base classes

    /**
    * From CEikAppUi, takes care of command handling.
    * @param aCommand command to be handled
    */
	void HandleCommandL(TInt aCommand);
	
	/**
	* From CEikAppUi, called when application switches to or from the foreground.
	* @param aForeground ETrue to switch to the foreground. EFalse to switch from the foreground.
	*/
	void HandleForegroundEventL(TBool aForeground);
	
private: // New functions

	/**
	* Reads connection setting from a settings file.
	*/
	void InternalizeConnInfoL();
	
	/**
	* Saves connection settings to a settings file.
	*/
	void ExternalizeConnInfoL();
	
	/**
	* Sets the automatic tasks loading in engine on, if AppView and AppUi aren't busy.
	*/
	void SetAutomaticUpdateL();

private: // Data members

	CTaskManagerAppView* iAppView;
	CTaskManagerEngine* iEngine;
	TTaskManagerConnInfo iConnectionInfo;
	TFileName iSettingsFile;
	TBool iViewBusy;
	TBool iUiBusy;
    
	};


#endif // __TASKMANAGER_APPUI_H__

// End of file


