/*
* ============================================================================
*  Name     : TTaskManagerConnInfo from TaskManagerConnInfo.h
*  Part of  : TaskManager
*  Created  : 15/03/2006 by Forum Nokia
*  Version  : 1.2
*  Copyright: Nokia Corporation
* ============================================================================
*/

#ifndef TASKMANAGERCONNINFO_H
#define TASKMANAGERCONNINFO_H

// INCLUDE FILES
#include "TaskManager.hrh"

#include <e32std.h>
#include <e32def.h>
#include <s32strm.h>

// CLASS DECLARATION

/**
* A class for holding connections settings.
*
*/
class TTaskManagerConnInfo
	{
public: // Constructors

	/**
	* Constructor
	*/
	TTaskManagerConnInfo();
	
public: // Getters and setters

	void SetServerAddress( const TDesC& aAddress );
	TBufC< KMaxServerNameLength > ServerAddress() const;
	
	void SetPort( const TInt aPort );
	const TInt Port() const;
	
	void SetUsername( const TDesC& aUsername );
	TBufC< KMaxUsernameLength > Username() const;
	
	void SetPassword( const TDesC& aPassword );
	TBufC< KMaxPasswordLength > Password() const;
	
	void SetIap( const TUint32& aId);
	TUint32 Iap() const;
	
public: // New functions

	/**
	* Saves connections setting to the stream.
	* @param aStream the stream where data is written.
	*/
	void ExternalizeL(RWriteStream& aStream) const;
	
	/**
	* Reads the connections settings from the stream.
	* @param aStream the stream where the data is read from.
	*/
	void InternalizeL(RReadStream& aStream);
	
private: // Data members

    // Default port, defined in .cpp file
    static const TInt               KDefaultPort;

	// Address of the server
	TBuf< KMaxServerNameLength >    iServerAddress;
	
	// Port number
	TInt iPort;
	
	// Username
	TBuf< KMaxUsernameLength >      iUsername;
	
	// Password
	TBuf< KMaxPasswordLength >      iPassword;
	
	// Default IAP;
	TUint32 iIap;
	
	};

#endif

// End of file





