/*
* ============================================================================
*  Name     : CTaskManagerConnForm from TaskManagerConnForm.cpp
*  Part of  : TaskManager
*  Created  : 15/03/2006 by Forum Nokia
*  Version  : 1.2
*  Copyright: Nokia Corporation
* ============================================================================
*/

// INCLUDE FILES
#include "TaskManagerConnForm.h"
#include "TaskManagerConnInfo.h"

#include <SocketTaskManager.rsg>
#include <avkon.hrh>		// EAknSoftkeyOk
#include <eikedwin.h>		// CEikEdwin
#include <aknnumedwin.h>	// CAknIntegerEdwin
#include <eikseced.h>		// CEikSecretEditor


// ================= MEMBER FUNCTIONS =======================

// constructor
CTaskManagerConnForm::CTaskManagerConnForm( TTaskManagerConnInfo& aConnInfo ): iConnInfo( aConnInfo )
	{
	}

// ----------------------------------------------------------
// CTaskManagerConnForm::RunDlgLD()
// Runs this form.
// ----------------------------------------------------------
//
TBool CTaskManagerConnForm::RunDlgLD( TTaskManagerConnInfo& aConnInfo )
	{
	CTaskManagerConnForm* self = new (ELeave) CTaskManagerConnForm( aConnInfo );
	return self->ExecuteLD( R_TASKMANAGER_CONNFORM_DIALOG );
	}

// ----------------------------------------------------------
// CTaskManagerConnForm::PreLayoutDynInitL()
// This function is called by the dialog framework before 
// the dialog is sized and laid out.
// ----------------------------------------------------------
//
void CTaskManagerConnForm::PreLayoutDynInitL()
	{
	CEikEdwin* editor;
	
	// set server name
	editor = static_cast< CEikEdwin* >( ControlOrNull( ETaskManagerIdServer ) );
	if( editor )
		{
		TPtrC ptr(iConnInfo.ServerAddress());
		editor->SetTextL(&ptr);
		}
	
	// set port number
	CAknIntegerEdwin* portEditor =
			   static_cast< CAknIntegerEdwin* >( ControlOrNull( ETaskManagerIdPort ) );
	if( portEditor )
		{
		portEditor->SetValueL(iConnInfo.Port());
		}
	
	// set username
	editor = static_cast< CEikEdwin* >( ControlOrNull( ETaskManagerIdUsername ) );
	if( editor )
		{
		TPtrC ptr(iConnInfo.Username());
		editor->SetTextL(&ptr);
		}
		
	// set password
	CEikSecretEditor* secretEditor =
		static_cast< CEikSecretEditor* >( ControlOrNull( ETaskManagerIdPassword ) );
	if (secretEditor)
		{
		TPtrC ptr(iConnInfo.Password());
		secretEditor->SetText(ptr);
		}
	}
	
// ----------------------------------------------------------
// CTaskManagerConnForm::OkToExitL()
// This function is invoked when the user presses a button in 
// the button panel. It is not called if the Cancel button is 
// activated.
// ----------------------------------------------------------
//	
TBool CTaskManagerConnForm::OkToExitL( TInt aButtonId )
	{
	if ( aButtonId == EAknSoftkeyOk )
		{
		CEikEdwin* editor;
		
		// save server name
		editor = static_cast< CEikEdwin* >( ControlOrNull( ETaskManagerIdServer ) );
		if( editor )
			{
			TBuf< KMaxServerNameLength > server;
			editor->GetText( server );
			iConnInfo.SetServerAddress( server );
			}
		
		// save port number
		CAknIntegerEdwin* portEditor =
				   static_cast< CAknIntegerEdwin* >( ControlOrNull( ETaskManagerIdPort ) );
		if( portEditor )
			{
			TInt port;
			portEditor->GetTextAsInteger( port );
			iConnInfo.SetPort( port );
			}
		
		// save username
		editor = static_cast< CEikEdwin* >( ControlOrNull( ETaskManagerIdUsername ) );
		if( editor )
			{
			TBuf< KMaxUsernameLength > username;
			editor->GetText( username );
			iConnInfo.SetUsername( username );
			}

		// save password
		CEikSecretEditor* secretEditor =
					 static_cast< CEikSecretEditor* >( ControlOrNull( ETaskManagerIdPassword ) );
		if( secretEditor )
			{
			TBuf< KMaxPasswordLength > password;
			secretEditor->GetText( password );
			iConnInfo.SetPassword( password );
			}
		}

	return ETrue;
	}
	
// End of file
