// TXTCPAN.H
//
//  2004 Nokia Corporation.  All rights reserved.
//

#ifndef __TXTFWDOP_H__
#define __TXTFWDOP_H__

#include <msvapi.h>     // CMsvOperation

_LIT(KTxtMtmFwdPrefix, "Fwd:");

// Progress information for forward operation

class TTxtMtmForwardOpProgress
    {
    public:
        enum TState
            {
            EInit,
            ECreateMessage,
            EFormatBodyText,
            EFinished
            };

    public:
        TState iState;
        TMsvId iFinalMsgId;
        TInt iError;
    };

// utility typedef of package buffer
typedef TPckgBuf <TTxtMtmForwardOpProgress> TTxtMtmForwardOpProgressBuf;


class CTxtMtmForwardOperation : public CMsvOperation
	{	
	public:
        static CTxtMtmForwardOperation* NewL(TMsvId aSourceMessage, TMsvId aDestinationFolder, CMsvSession& aMsvSession, TRequestStatus& aObserverRequestStatus);
        ~CTxtMtmForwardOperation();

	public:	// from CMsvOperation		
		virtual const TDesC8& ProgressL();
        virtual const TDesC8& FinalProgress();

	public:	// from CActive
		virtual void DoCancel();
		virtual void RunL();
        virtual TInt RunError(TInt aError);

    private:
        void CreateMessageL();
        void FormatBodyTextL();

    private:
		CTxtMtmForwardOperation(TMsvId aSourceMessage, TMsvId aDestinationFolder, CMsvSession& aMsvSession, TRequestStatus& aObserverRequestStatus);
        void ConstructL();		

	private:
		TTxtMtmForwardOpProgress iProgress;
        TTxtMtmForwardOpProgressBuf iProgressBuf;
        TMsvId iSourceMessage; 
        TMsvId iDestinationFolder;
        CMsvEntry* iMsvEntry;
	};

#endif  // __TXTFWDOP_H__
