// txdeinstall.cpp
//
//  2006 Nokia Corporation.  All rights reserved.
//

// includes
#include <e32base.h>
#include <e32cons.h>
#include <f32file.h>
#include <msvapi.h>
#include <msvids.h>     // KMsvRootIndexEntryId
#include <msvuids.h>    // KUidMsvServiceEntry
#include "txut.h"

//LOCAL_D const TInt KUidMsgTypeTextValue = 0x10005247;
//LOCAL_D const TUid KUidMsgTypeText = { KUidMsgTypeTextValue};
//LOCAL_D const TUid KTxtMtmTechnologyTypeUid	= { KUidMsgTypeTextValue};

LOCAL_D CConsoleBase* console;
LOCAL_C void consoleUIDeinstallL();
LOCAL_C void DoDeinstallL();
LOCAL_C void ClearMessageEntriesL(CMsvSession& aSession);
LOCAL_C void ClearEntriesFromContextL(CMsvEntry& aEntry, TMsvId aContext);

// constants
_LIT(KMTMDataFileName,"txtmtm.rsc");
_LIT(KMTMDataLocation,"\\resource\\messaging\\Mtm\\");
_LIT(KTxtTitle,"TextMTM deinstall");
_LIT(KFormatFailed,"failed: leave code=%d");

// Dummy observer class to absorb Message Server session events
class TDummyObserver : public MMsvSessionObserver
	{
public:
	void HandleSessionEventL(TMsvSessionEvent /*aEvent*/, TAny* /*aArg1*/, TAny* /*aArg2*/, TAny* /*aArg3*/) {};
	};


LOCAL_C void FindFileL(const TDesC& aFileName, const TDesC& aLocation, TFileName& aRetVal)
    {
    RFs fs;
    User::LeaveIfError(fs.Connect());
    CleanupClosePushL(fs);
    TFindFile finder(fs);
    User::LeaveIfError(finder.FindByDir(aFileName, aLocation));
    aRetVal = finder.File();
    CleanupStack::PopAndDestroy();
    }


LOCAL_C void DoDeinstallL()
// Set up Message Server session and install Text MTM group
	{
    TFileName filename;
    FindFileL(KMTMDataFileName, KMTMDataLocation, filename);

	TDummyObserver ob;
	CMsvSession* session = CMsvSession::OpenSyncL(ob);
	CleanupStack::PushL(session);
    ClearMessageEntriesL(*session);

	TInt err=session->DeInstallMtmGroup(filename);
	if (err!=KErrNone && err!=KErrNotFound)
		User::Leave(err);
	
	CMTMTxtSettings* settings = CMTMTxtSettings::NewL();
	CleanupStack::PushL(settings);
	settings->DeleteDefaultServiceSettingL();
	CleanupStack::PopAndDestroy(settings);

	CleanupStack::PopAndDestroy(session); // session

	RFs fs;
	fs.Connect();
    CFileMan* fileman = CFileMan::NewL(fs);
	_LIT(KMTMDir,"\\data\\TextMTMService\\");
	fileman->RmDir(KMTMDir);
    delete fileman;
	fs.Close();

	}

LOCAL_C void ClearMessageEntriesL(CMsvSession& aSession)
    {
    TMsvSelectionOrdering ordering;
    ordering.SetShowInvisibleEntries(ETrue);
    CMsvEntry* entry = CMsvEntry::NewL(aSession, KMsvRootIndexEntryId, ordering);
    CleanupStack::PushL(entry);

    ClearEntriesFromContextL(*entry, KMsvGlobalInBoxIndexEntryId);
    ClearEntriesFromContextL(*entry, KMsvGlobalOutBoxIndexEntryId);
    ClearEntriesFromContextL(*entry, KMsvSentEntryId);
    ClearEntriesFromContextL(*entry, KMsvDeletedEntryFolderEntryId);
    ClearEntriesFromContextL(*entry, KMsvDraftEntryId);
    ClearEntriesFromContextL(*entry, KMsvRootIndexEntryId);

    CleanupStack::PopAndDestroy(entry);
    }

LOCAL_C void ClearEntriesFromContextL(CMsvEntry& aEntry, TMsvId aContext)
    {
    aEntry.SetEntryL(aContext);

    CMsvEntrySelection* sel = aEntry.ChildrenWithMtmL(KTxtMtmTechnologyTypeUid);
    CleanupStack::PushL(sel);

    const TInt count = sel->Count();

    for(TInt ii = 0; ii < count; ii++)
        aEntry.DeleteL(sel->At(ii));

    CleanupStack::PopAndDestroy(sel);
    }

LOCAL_C void consoleUIDeinstallL()
// Set up simple console UI
    {
	// Construct and install the active scheduler
	CActiveScheduler* scheduler = new (ELeave) CActiveScheduler;
	CleanupStack::PushL(scheduler);
	CActiveScheduler::Install(scheduler);

	console=Console::NewL(KTxtTitle,TSize(KConsFullScreen,KConsFullScreen));
	CleanupStack::PushL(console);
	TRAPD(error,DoDeinstallL()); // call install function

	if (error)
		console->Printf(KFormatFailed, error);

	console->Getch();

	CleanupStack::PopAndDestroy(2, scheduler); // console, scheduler
	}

GLDEF_C TInt E32Main()
	{
	__UHEAP_MARK;
	CTrapCleanup* cleanup=CTrapCleanup::New(); // get clean-up stack
	TRAPD(error,consoleUIDeinstallL());
	delete cleanup; // destroy clean-up stack
	__UHEAP_MARKEND;
	return 0;
    }
