// TXCLIENT.H
//
//  2004 Nokia Corporation.  All rights reserved.
//


#if !defined (__TXCLIENT_H__)
#define __TXCLIENT_H__

// system includes
#include <e32base.h>
#include <badesca.h>
#include <msvapi.h>
#include <mtclbase.h>
#include <txut.h>       // TMTMTxtSettings

const TUint KAddresseeListResizeGranularity = 5;

// 
// CTextMtmClient
//		Implements CBaseMtm to provide Client-side Text MTM		
//

class CTextMtmClient : public CBaseMtm
	{
public:
	//Construction and destruction 
	IMPORT_C static CTextMtmClient* NewL(CRegisteredMtmDll& aRegisteredMtmDll,CMsvSession& aMsvSession);
	~CTextMtmClient();

public:
    // from CBaseMtm

	// Store and restore entry data 
	virtual void SaveMessageL(); 
	virtual void LoadMessageL();

	// Response message creation 
	virtual CMsvOperation* ReplyL(TMsvId aDestination, TMsvPartList aPartlist, TRequestStatus& aCompletionStatus);
	virtual CMsvOperation* ForwardL(TMsvId aDestination, TMsvPartList aPartList, TRequestStatus& aCompletionStatus);

	// Validation and search 
	virtual TMsvPartList ValidateMessage(TUint aPartList);
	virtual TMsvPartList Find(const TDesC& aTextToFind, TMsvPartList aPartList);

	// Addressees have no meaning in the text mtm.
	virtual void AddAddresseeL(const TDesC& aRealAddress);
	virtual void AddAddresseeL(const TDesC& aRealAddress, const TDesC& aAlias);
	virtual void RemoveAddressee(TInt aIndex);

	// MTM-specific functionality
	virtual TInt QueryCapability(TUid aCapability, TInt& aResponse);
	virtual void InvokeSyncFunctionL(TInt aFunctionId,const CMsvEntrySelection& aSelection, TDes8& aParameter);
	virtual CMsvOperation* InvokeAsyncFunctionL(TInt aFunctionId,const CMsvEntrySelection& aSelection, TDes8& aParameter, TRequestStatus& aCompletionStatus);

	void CreateAttachmentL(const TDesC& aFilePath, const TDesC8& aMimeType, TRequestStatus& aStatus);
	void CreateAttachmentL(RFile& aFile, const TDesC8& aMimeType, TRequestStatus& aStatus);
	void CreateLinkedAttachmentL(const TDesC& aFilePath, const TDesC8& aMimeType, TRequestStatus& aStatus);
	void CreateMessageAttachmentL(TMsvId aAttachmentId, TRequestStatus& aStatus);
	
	TMsvId DefaultServiceL() const;
	void RemoveDefaultServiceL();
	void ChangeDefaultServiceL(const TMsvId& aService);
public:
	// Text-specific
	TMTMTxtSettings& TxtSettings();
	CMTMTxtSettings& Settings();
protected:
    // from CBaseMtm
	virtual void ContextEntrySwitched(); 

protected:
	CTextMtmClient(CRegisteredMtmDll& aRegisteredMtmDll,CMsvSession& aMsvSession);
	void ConstructL();

private: // Properties
	TMTMTxtSettings iTxtSettings;
	CMTMTxtSettings* iSettings;
	};


//
// inline implementations
//

// Addresses are not used in this MTM
inline void CTextMtmClient::AddAddresseeL(const TDesC& /*aRealAddress*/) {};
inline void CTextMtmClient::AddAddresseeL(const TDesC& /*aRealAddress*/, const TDesC& /*aAlias*/) {};
inline void CTextMtmClient::RemoveAddressee(TInt /*aIndex*/) {};
inline TMTMTxtSettings& CTextMtmClient::TxtSettings()
	{
	return iTxtSettings;
	}

inline CMTMTxtSettings& CTextMtmClient::Settings()
	{
	return *iSettings;
	}
#endif // __TXCLIENT_H__
