// txin.cpp
//
//  2006 Nokia Corporation.  All rights reserved.
//

// includes
#include <e32base.h>
#include <e32cons.h>
#include <msvapi.h>
#include <mtclreg.h>
#include <MTUDREG.H> 

#include "txclient.h"
#include "txti.h"

LOCAL_D CConsoleBase* console;
LOCAL_C void consoleUIInstallL();
LOCAL_C void DoInstallL();
_LIT(KMTMDataLocation,"C:\\RESOURCE\\MESSAGING\\MTM\\txtmtm.rsc");

_LIT(KTxtTitle,"TextMTM install");
_LIT(KFormatFailed,"failed: leave code=%d");
_LIT(KFormatSuccess,"MTM install succeeded");

// Dummy observer class to absorb Message Server session events
class TDummyObserver : public MMsvSessionObserver
	{
public:
	void HandleSessionEventL(TMsvSessionEvent /*aEvent*/, TAny* /*aArg1*/, TAny* /*aArg2*/, TAny* /*aArg3*/) {};
	};



LOCAL_C void DoInstallL()
// Set up Message Server session and install Text MTM group
	{
  
	
	_LIT(K1, "phase 1 ok \n");
	_LIT(K2, "phase 2 ok \n");
	_LIT(KServiceDirectoryAlreadyCreated, "directory TextMTMService already created on c drive \n");
	_LIT(KServiceDirectoryCreated, "directory TextMTMService service created on c drive \n");
	
	
	TDummyObserver ob;
	CMsvSession* session = CMsvSession::OpenSyncL(ob);
	CleanupStack::PushL(session);
	TInt err=session->DeInstallMtmGroup(KMTMDataLocation);
	if (err!=KErrNone && err!=KErrNotFound)
		User::Leave(err);
	User::LeaveIfError(session->InstallMtmGroup(KMTMDataLocation));
	
	// Installing is ok
	console->Printf(K1);


	CClientMtmRegistry* cl = CClientMtmRegistry::NewL(*session);	
	if(!cl->IsPresent(KUidMsgTypeText))	User::Leave(KErrNotFound);
	
	// Resource file was found
	console->Printf(K2);

	CTextMtmClient* climpl=NULL;
	climpl = (CTextMtmClient*)cl->NewMtmL(KUidMsgTypeText);


	delete climpl;
	delete cl;

	CleanupStack::PopAndDestroy(session); // session

	RFs fs;
	fs.Connect();
	
	_LIT(KNewDir,"\\data\\TextMTMService\\");
	
	// Try to create the directory
	TInt err4 = fs.MkDir(KNewDir);

	// In case the directory is already there...
	if (err4==KErrAlreadyExists) 
		{
		console->Printf(KServiceDirectoryAlreadyCreated);
		}
		
	// Directory not yet created...
	else if (err4==KErrNone)  
		{
		console->Printf(KServiceDirectoryCreated);
			
		}

	
	fs.Close();
	

	}

LOCAL_C void consoleUIInstallL()
// Set up simple console UI
    {
	// Construct and install the active scheduler
	CActiveScheduler* scheduler = new (ELeave) CActiveScheduler;
	CleanupStack::PushL(scheduler);
	CActiveScheduler::Install(scheduler);

	console=Console::NewL(KTxtTitle,TSize(KConsFullScreen,KConsFullScreen));
	CleanupStack::PushL(console);
	

	TRAPD(error,DoInstallL()); // call install function
	if (error != KErrNone)
		console->Printf(KFormatFailed, error);
    else
        console->Printf(KFormatSuccess);
	console->Getch();
	CleanupStack::PopAndDestroy(2, scheduler); // console, scheduler
	}

GLDEF_C TInt E32Main()
	{
	__UHEAP_MARK;
	CTrapCleanup* cleanup=CTrapCleanup::New(); // get clean-up stack
	TRAPD(error,consoleUIInstallL());
	delete cleanup; // destroy clean-up stack
	__UHEAP_MARKEND;
	return error;
    }
    
