//
//  2004 Nokia Corporation.  All rights reserved.
//

#ifndef __TXTMTMCREATEDOP_H__
#define __TXTMTMCREATEDOP_H__

#include <mtmuibas.h>
#include <msvapi.h>     // CMsvOperation


// Progress information for create operation

class TTxtMtmCreateOpProgress
    {
    public:
        enum TState
            {
            EInit,
            ECreateMessage,
            EEditMessage,
            EFinished
            };

    public:
        TState iState;
        TMsvId iFinalMsgId;
        TInt iError;
    };

// utility typedef of package buffer
typedef TPckgBuf <TTxtMtmCreateOpProgress> TTxtMtmCreateOpProgressBuf;


class CTxtMtmCreateOperation : public CMsvOperation
	{	
	public:
        static CTxtMtmCreateOperation* NewL(const TMsvEntry& aEntry, CMsvEntry& aParent, CMsvSession& aMsvSession, CBaseMtmUi& aMtmUi, TRequestStatus& aObserverRequestStatus);
        ~CTxtMtmCreateOperation();

	public:	// from CMsvOperation		
		virtual const TDesC8& ProgressL();
        virtual const TDesC8& FinalProgress();

	public:	// from CActive
		virtual void DoCancel();
		virtual void RunL();
        virtual TInt RunError(TInt aError);

    private:
		void CreateBodyIfNoneL();
        void CreateMessageL();
        void ScheduleEditL();
        void Schedule(TInt aError);

    private:
		CTxtMtmCreateOperation(const TMsvEntry& aEntry, CMsvEntry& aParent, CMsvSession& aMsvSession, CBaseMtmUi& aMtmUi, TRequestStatus& aObserverRequestStatus);
        void ConstructL();		

	private:
		TTxtMtmCreateOpProgress iProgress;
        TTxtMtmCreateOpProgressBuf iProgressBuf;
        TMsvEntry iEntry; 
        CMsvEntry& iParent;
     
        CBaseMtmUi& iMtmUi;
        CMsvOperation* iOp;
	};

#endif  // __TXTMTMCREATEDOP_H__
