//
//  2004 Nokia Corporation.  All rights reserved.
//


#ifndef __TXTU_H__
#define __TXTU_H__

// system include
#include <mtmuibas.h>       // CBaseMtmUi

// user include
#include "../../Util/inc/txut.h"	 //service settings

//
// CTextMtmUi: User Interface MTM
//

class CTextMtmUi : public CBaseMtmUi
	{
public:
	// Construction
	static CTextMtmUi* NewL(CBaseMtm& aBaseMtm, CRegisteredMtmDll& aRegisteredMtmDll);
	// Destruction
	~CTextMtmUi();



public:
	// Context-specific APIs from CBaseMtmUi
	virtual CMsvOperation* CancelL(TRequestStatus& aStatus, const CMsvEntrySelection& aSelection);

	virtual CMsvOperation* OpenL(TRequestStatus& aStatus); 
	virtual CMsvOperation* OpenL(TRequestStatus& aStatus, const CMsvEntrySelection& aSelection); 

	virtual CMsvOperation* CloseL(TRequestStatus& aStatus); 
	virtual CMsvOperation* CloseL(TRequestStatus& aStatus, const CMsvEntrySelection& aSelection);

	// Launches editor/settings dialog as appropriate  
	virtual CMsvOperation* EditL(TRequestStatus& aStatus);
	virtual CMsvOperation* EditL(TRequestStatus& aStatus, const CMsvEntrySelection& aSelection) ;

	// Launches viewer/settings dialog as appropriate  
	virtual CMsvOperation* ViewL(TRequestStatus& aStatus);
	virtual CMsvOperation* ViewL(TRequestStatus& aStatus, const CMsvEntrySelection& aSelection);

	// Copy and move
	virtual CMsvOperation* CopyToL(const CMsvEntrySelection& aSelection, TRequestStatus& aStatus);
	virtual CMsvOperation* MoveToL(const CMsvEntrySelection& aSelection, TRequestStatus& aStatus);
	virtual CMsvOperation* CopyFromL(const CMsvEntrySelection& aSelection, TMsvId aTargetId, TRequestStatus& aStatus);
	virtual CMsvOperation* MoveFromL(const CMsvEntrySelection& aSelection, TMsvId aTargetId, TRequestStatus& aStatus);

	// Creat reply/forward message entries
    virtual CMsvOperation* ReplyL(TMsvId aDestination, TMsvPartList aPartList, TRequestStatus& aCompletionStatus);
	virtual CMsvOperation* ForwardL(TMsvId aDestination, TMsvPartList aPartList, TRequestStatus& aCompletionStatus);

	// Create/delete/undelete
	virtual CMsvOperation* CreateL(const TMsvEntry& aEntry, CMsvEntry& aParent, TRequestStatus& aStatus);
	virtual CMsvOperation* DeleteFromL(const CMsvEntrySelection& aSelection,TRequestStatus& aStatus);
	CMsvOperation* DeleteServiceL(const TMsvEntry& aService, TRequestStatus& aStatus);

public:
	// Operation APIs from CBaseMtmUi
	virtual void InvokeSyncFunctionL(TInt aFunctionId, const CMsvEntrySelection& aSelection, TDes8& aParameter);
	virtual CMsvOperation* InvokeAsyncFunctionL(TInt aFunctionId, const CMsvEntrySelection& aSelection, TRequestStatus& aCompletionStatus, TDes8& aParameter);
	virtual TInt GetProgress(const TDesC8& aProgress, TBuf<EProgressStringMaxLen>& aReturnString, TInt& aTotalEntryCount, TInt& aEntriesDone,
		TInt& aCurrentEntrySize, TInt& aCurrentBytesTrans) const;


public:
	CMsvOperation* LaunchEditorApplicationL(TRequestStatus& aStatus, TMsvId aId, TBool aReadOnly);
    CMsvOperation* LaunchViewerApplicationL(TRequestStatus& aStatus, TMsvId aId);


protected: 
	// from CBaseMtmUi
	void GetResourceFileName(TFileName& aFileName) const;

protected:
	CTextMtmUi(CBaseMtm& aBaseMtm, CRegisteredMtmDll& aRegisteredMtmDll);
	void TxtConstructL();

private:
    // private utility methods
	CMsvOperation* DoCopyMoveToL(const CMsvEntrySelection& aSelection, TRequestStatus& aStatus, TBool aCopy);
	CMsvOperation* DoCopyMoveFromL(const CMsvEntrySelection& aSelection, TMsvId aTargetId, TRequestStatus& aStatus, TBool aCopy);
	void ValidateSelectionL(const CMsvEntry& aParent, const CMsvEntrySelection& aSelection);
	CMsvOperation* MessageEditL(TRequestStatus& aStatus);
	CMsvOperation* ServiceEditL(TRequestStatus& aStatus);
	void SetProgressSuccess(TPckgBuf<TMsvLocalOperationProgress>& aProgress,TMsvId aId);
    void CallNewMessagesL();

	void CreateBodyIfNoneL();

private:
	TMsvId iServiceId;
    TInt iNewResourceFileOffset;
    HBufC* iResourceFileName;
   
	};


//
//	CEditRemoteOperation: remote edit operation
//
class CEditRemoteOperation : public CMsvOperation
	{
	enum TEditRemoteState
		{
		EStateFinished=0,
		EStateEditing,
		EStateCopying,
		};
	
	public:
		CEditRemoteOperation(CTextMtmUi& aMtmUi, CMsvSession& aMsvSession, 
			TInt aPriority, TRequestStatus& aObserverRequestStatus);
		~CEditRemoteOperation();

    public:
        void StartL(TMsvEntry& aSourceEntry);
        

	public:	// from CMsvOperation		
		virtual const TDesC8& ProgressL();

	public:	// from CActive
		virtual void DoCancel();
		virtual void RunL();

	private:
		CTextMtmUi& iMtmUi;
		TBuf8<10> iProgress;
		CMsvOperation* iCopyOperation;
		CMsvOperation* iEditOperation;
		TEditRemoteState iState;
	};

#endif // __TXTU_H__
