//
//  2004 Nokia Corporation.  All rights reserved.
//

// class include
#include "txtmtmeditorop.h"

//system include
#include <aknquerydialog.h> // CAknTextQueryDialog
#include <apparc.h>    // CApaApplication
#include <msvids.h>    // KMsvLocalServiceIndexEntryId
#include <msvuids.h>   // KUidMsvMessageEntry
#include <eikenv.h>
#include <coemain.h>
#include <eikproc.h>
#include <eikdoc.h>
#include <apacln.h>
#include <s32mem.h>
#include "txtviewerservice.h"
#include <apgcli.h>
// user include
#include "txtupan.h"
#include <aknnotewrappers.h>
#include "txtu.h"

#include "txtcmds.hrh"
// constants
const TInt KTxtMtmEditorOpBufStoreSize = 127;


CTxtMtmEditorOperation* CTxtMtmEditorOperation::NewL(const TMsvId& aId, TOpenMode aMode, CMsvSession& aMsvSession, TRequestStatus& aObserverRequestStatus, CTextMtmUi& aMtmUi)
    {
    CTxtMtmEditorOperation* self = new (ELeave) CTxtMtmEditorOperation(aId, aMode, aMsvSession, aObserverRequestStatus, aMtmUi);
    CleanupStack::PushL(self);
    self->ConstructL();
    CleanupStack::Pop(self);
    return self;
    }


CTxtMtmEditorOperation::CTxtMtmEditorOperation(const TMsvId& aId, TOpenMode aMode, CMsvSession& aMsvSession, TRequestStatus& aObserverRequestStatus,CTextMtmUi& aMtmUi)
 : CMsvOperation(aMsvSession, EPriorityStandard, aObserverRequestStatus),iId(aId),iMode(aMode), iMtmUi(aMtmUi)
    {
    CActiveScheduler::Add(this);
    }


void CTxtMtmEditorOperation::ConstructL()
    {
	// Use RLibrary object to get hands on the DLL
    RLibrary library;

    _LIT(KDllName,"txtu.DLL");
 
    // Dynamically load DLL
    User::LeaveIfError(library.Load(KDllName));

	// Make the handle process wide to avoid Cone 36 in debug builds
    RLibrary dup = library;
	
	TInt err;
	
    err=library.Duplicate(RThread());
	
	if (err==KErrNone)
    	{
     	dup.Close(); 
    	}

	//Set the observer to pending state
    iObserverRequestStatus = KRequestPending;
    
    //Set us to pending state
    iStatus = KRequestPending;

	//Set us active
    SetActive();

	//Launch the editor
    LaunchEditorL();
    }


CTxtMtmEditorOperation::~CTxtMtmEditorOperation()
    {
    Cancel();
    }


const TDesC8& CTxtMtmEditorOperation::ProgressL()
    {
    iProgressBuf() = iProgress;
    return iProgressBuf;
    }


const TDesC8& CTxtMtmEditorOperation::FinalProgress()
    {
    __ASSERT_ALWAYS(!IsActive(), User::Panic(KTEXTMTMUIPanic, ETextMtmUiOperationActive));
    iProgressBuf() = iProgress;
    return iProgressBuf;
    }


TInt CTxtMtmEditorOperation::RunError(TInt aError)
    {  
	// Complete the requesting active object
    iProgress.iError = aError;
    TRequestStatus* stat = &iObserverRequestStatus;
    User::RequestComplete(stat, aError);
    return KErrNone;
    }


void CTxtMtmEditorOperation::DoCancel()
    {
    delete iMonitor;

    iService.Close();
    
	// Complete in order to continue Cancel's WaitForRequest
    TRequestStatus* stat1 = &iStatus;
    User::RequestComplete(stat1, KErrCancel);

	// Complete observer
    TRequestStatus* stat2 = &iObserverRequestStatus;
    User::RequestComplete(stat2, KErrCancel);
    }


void CTxtMtmEditorOperation::RunL()
    {
    User::LeaveIfError(iStatus.Int());

    switch(iProgress.iState)
        {
        case TTxtMtmEditorOpProgress::EEditorLaunched:
            iProgress.iState = TTxtMtmEditorOpProgress::EEditorLaunched;
			TRequestStatus* stat = &iObserverRequestStatus;
    		User::RequestComplete(stat, iStatus.Int());
            break;            
        default:
            break;
        }
    }


void CTxtMtmEditorOperation::HandleServerAppExit( TInt aReason )
	{
	TRequestStatus* stat = &iStatus;
    User::RequestComplete(stat, KErrNone);

	MAknServerAppExitObserver::HandleServerAppExit( aReason );	
        
	delete iMonitor;
	iService.Close();
	}


void CTxtMtmEditorOperation::LaunchEditorL()
    {
  	TEditorParameters aParams;
    
    aParams.iEntry = iId;
 		
	if (iMode==EEdit) aParams.iOpenedForEditing=ETrue;
		else aParams.iOpenedForEditing=EFalse;
	
   	TUid uid = TUid::Uid(0xA00058BD);
		
    iService.ConnectChainedAppL( uid );
  	
   	iMonitor = CApaServerAppExitMonitor::NewL(
            iService,
            *this,
            CActive::EPriorityStandard);

	iProgress.iState=TTxtMtmEditorOpProgress::EEditorLaunched;     

    iService.OpenL( aParams);
    }
    
        
