// TXTU.CPP
//
//  2004 Nokia Corporation.  All rights reserved.

// class includes
#include "txtu.h"

// system includes
#include <aknquerydialog.h> // CAknTextQueryDialog
#include <aknglobalnote.h>  // CAknInformationNote
#include <aknnotewrappers.h>
#include <apffndr.h>        // CApaScanningAppFinder
#include <bautils.h>
#include <eikdialg.h>
#include <eikenv.h>         // CEikonEnv
#include <eikon.hrh>        // EEikBidCancel, EEikBidTab
#include <eikon.rsg>
#include <eikrted.h>        // CEikRichTextEditor
#include <msvids.h>         // messaging
#include <msvuids.h>        // messaging
#include <stringloader.h>   // StringLoader
#include <txtrich.h>        // CRichText
#include <mncnnotification.h> 

#include <txtu.rsg>
#include "../../Client/inc/TXCLIENT.H"
#include "TXTU.HRH"

// User includes
#include "txtcmds.hrh"    //commands accepted by the server side mtms
#include "txtmtmcreateop.h" // CTxtMtmCreateOperation
#include "txtmtmeditop.h"   // CTxtMtmEditRemoteOperation
#include "txtmtmeditorop.h"
#include "txtucmds.hrh"
#include "txtupan.h"
#include "txtu.hrh"

 
#include <aknnotewrappers.h>


// Constants
const TInt KPriorityLessThanStandard =	CActive::EPriorityStandard-1;
_LIT(KTxtuMtmUiResourceFile,"txtu.rsc");
_LIT(KTxtuMtmUiResourcePath, "\\resource\\messaging\\");
_LIT(KTextMTMMsgPath, "C:\\data\\TextMTMService\\");
_LIT(KTextMtmCPrompt, "C:\\");
_LIT(KTextMtmName, "TextMTM name");
_LIT(KOnlyOneTextMtmAllowed, "Only one TextMTM is allowed.");

//
// CTextMtmUi: User Interface MTM
//


// ----------------------------------------------------------------------------
//
//	Construction and destruction
//
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
CTextMtmUi* CTextMtmUi::NewL(CBaseMtm& aBaseMtm, CRegisteredMtmDll& aRegisteredMtmDll)
	{

	CTextMtmUi* self=new(ELeave) CTextMtmUi(aBaseMtm, aRegisteredMtmDll);
	CleanupStack::PushL(self);
	self->TxtConstructL();
	CleanupStack::Pop();
	return self;
	}


// ----------------------------------------------------------------------------
CTextMtmUi::CTextMtmUi(CBaseMtm& aBaseMtm, CRegisteredMtmDll& aRegisteredMtmDll)
	:	CBaseMtmUi(aBaseMtm, aRegisteredMtmDll)
	{
	}


// ----------------------------------------------------------------------------
CTextMtmUi::~CTextMtmUi()
	{
    // remove the resource file we added to the CCoeEnv
	iCoeEnv->DeleteResourceFile(iNewResourceFileOffset);
    delete iResourceFileName;
	}


// ----------------------------------------------------------------------------
void CTextMtmUi::TxtConstructL()
	{
	

	
	// Get resource file name
	TFileName resourceFileName;
    TxtUtils::FindFileL(KTxtuMtmUiResourceFile, KTxtuMtmUiResourcePath, resourceFileName);
    iResourceFileName = resourceFileName.AllocL();

	// Now try to find a resource file that matches the particular locale, if one
    // exists and the locale has been set
	BaflUtils::NearestLanguageFile(iCoeEnv->FsSession(), resourceFileName);

	// Add the resource file to the CCoeEnv
    TRAPD(ret, iNewResourceFileOffset=iCoeEnv->AddResourceFileL(resourceFileName));

	if (ret != KErrExtended)        // This leave code means that the resource file is being used by 2 DLLs in the same process
	
		User::LeaveIfError(ret);
	
	
	CBaseMtmUi::ConstructL();
	}


// ----------------------------------------------------------------------------
CMsvOperation* CTextMtmUi::CancelL(TRequestStatus& /*aStatus*/, const CMsvEntrySelection& /*aSelection*/)
	{
	User::Leave(KErrNotSupported); // no cancelling
	return NULL;
	}


// ----------------------------------------------------------------------------
// Resource file loading
//
void CTextMtmUi::GetResourceFileName(TFileName& aFileName) const
	{
	aFileName= *iResourceFileName;
	}

// ----------------------------------------------------------------------------
//
//	Entry manipulation
//
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
// Open
//
CMsvOperation* CTextMtmUi::OpenL(TRequestStatus& aStatus)
	{
	__ASSERT_DEBUG(iBaseMtm.Entry().Entry().iType==KUidMsvMessageEntry, Panic(ETextMtmUiOnlyWorksWithMessageEntries));
	TMsvId parent = iBaseMtm.Entry().Entry().Parent();
	iServiceId = iBaseMtm.Entry().Entry().iServiceId;	
	// We allow only the ones in drafts to be edited
	if (parent==KMsvDraftEntryIdValue) 	
		return EditL(aStatus);
	else return ViewL(aStatus);
	}


// ----------------------------------------------------------------------------
// Open selection
//
CMsvOperation* CTextMtmUi::OpenL(TRequestStatus& aStatus, const CMsvEntrySelection& aSelection)
	{
	__ASSERT_DEBUG(aSelection.Count(), Panic(ETextMtmUiEmptySelection));
	iBaseMtm.SwitchCurrentEntryL(aSelection.At(0));
	return OpenL(aStatus);
	}


// ----------------------------------------------------------------------------
// Close
//
CMsvOperation* CTextMtmUi::CloseL(TRequestStatus& aStatus)
	{
	__ASSERT_DEBUG(iBaseMtm.Entry().Entry().iType==KUidMsvMessageEntry, Panic(ETextMtmUiOnlyWorksWithMessageEntries));

	// Nothing to do for this MTM
	TPckgBuf<TMsvLocalOperationProgress> progress;
	SetProgressSuccess(progress,iBaseMtm.Entry().Entry().Id());

	CMsvCompletedOperation* op=CMsvCompletedOperation::NewL(Session(), Type(),
		progress, KMsvLocalServiceIndexEntryId,aStatus);
	return op;
	}


// ----------------------------------------------------------------------------
// Close selection
//
CMsvOperation* CTextMtmUi::CloseL(TRequestStatus& aStatus, const CMsvEntrySelection& aSelection)
	{
	__ASSERT_DEBUG(aSelection.Count(), Panic(ETextMtmUiEmptySelection));
	iBaseMtm.SwitchCurrentEntryL(aSelection.At(0));
	return CloseL(aStatus);
	}


// ----------------------------------------------------------------------------
CMsvOperation* CTextMtmUi::CreateL(const TMsvEntry& aEntry, CMsvEntry& aParent, TRequestStatus& aStatus)
	{
	
	if ( aEntry.iType == KUidMsvMessageEntry )
    	{
    	CTextMtmClient* client = static_cast<CTextMtmClient*>(&iBaseMtm);
    	TRAPD( error, client->DefaultServiceL();)
		// We won't allow to create a message entry if there is no default service 
    	// (i.e. service has not yet been created).
    	if (error == KErrNotFound)
        	{
	    	CAknQueryDialog* dlg = CAknQueryDialog::NewL();
	    	dlg->ExecuteLD(R_CONF_QUERY_OK_EMPTY);
    		TPckgBuf<TMsvLocalOperationProgress> progress;
        	SetProgressSuccess(progress, iBaseMtm.Entry().Entry().Id());
        	return CMsvCompOperation::NewL(Session(), Type(), progress, 
				iServiceId, aStatus);
        	}

    	}
	else
	    {
		CTextMtmClient* client = static_cast<CTextMtmClient*>(&iBaseMtm);

		// Set default service 
		client->ChangeDefaultServiceL(iBaseMtm.Entry().Entry().iServiceId);
			
		
	    }
	    
    return CTxtMtmCreateOperation::NewL(aEntry, aParent, Session(), *this, aStatus);
	
	}


// ----------------------------------------------------------------------------
CMsvOperation* CTextMtmUi::EditL(TRequestStatus& aStatus)
// Edit
	{
	TUid type = iBaseMtm.Entry().Entry().iType;
	iServiceId = iBaseMtm.Entry().Entry().iServiceId;	
	__ASSERT_DEBUG(type==KUidMsvMessageEntry || type==KUidMsvServiceEntry,
		Panic(ETextMtmUiWrongEntryType));

	if ( type == KUidMsvMessageEntry )
		return MessageEditL(aStatus);
	else
		return ServiceEditL(aStatus);
	}


// ----------------------------------------------------------------------------
// Message editing
//
CMsvOperation* CTextMtmUi::MessageEditL(TRequestStatus& aStatus)
	
	{
	// If the entry is local, then just launch the editor
	// application.

	
	if ( iServiceId == KMsvLocalServiceIndexEntryId )
		{
		return LaunchEditorApplicationL(aStatus, 
			iBaseMtm.Entry().Entry().Id(), ETrue);
		}

	
	// Otherwise, we just create a completed operation and
	// return that. Other option here would be to copy a remote
	// entry to local folder and start editing.   
	

	CMsvOperation* op=NULL;

	TPckgBuf<TMsvLocalOperationProgress> progress;
	SetProgressSuccess(progress, iBaseMtm.Entry().Entry().Id());
	op = CMsvCompOperation::NewL(Session(), Type(), progress, 
					iServiceId, aStatus);
			
	return op;


	}


// ----------------------------------------------------------------------------
// Service edit
//
// We only hit this function when a new service is created
//
//
CMsvOperation* CTextMtmUi::ServiceEditL(TRequestStatus& aStatus)
	{
	
	aStatus = KRequestPending;

	CTextMtmClient* client = static_cast<CTextMtmClient*>(&iBaseMtm);

	TBuf<30> mtmName = iBaseMtm.Entry().Entry().iDetails;
	CAknTextQueryDialog* dlg = CAknTextQueryDialog::NewL(mtmName);
	CleanupStack::PushL(dlg);
	dlg->SetPromptL(KTextMtmName);
	CleanupStack::Pop(dlg);
	if (dlg->ExecuteLD(R_DATAQUERY_DIALOG))
	    {
    	// Change default service to the service we edit 
    	// Implementation will store settings to Central Repository 
    	client->ChangeDefaultServiceL(iBaseMtm.Entry().Entry().iServiceId);
    	TMsvEntry entry = iBaseMtm.Entry().Entry();
    	entry.iDetails.Set(mtmName);
    	iBaseMtm.Entry().ChangeL(entry);
	    }

    // return completed operation
    CMsvOperation* op=NULL;
	TPckgBuf<TMsvLocalOperationProgress> progress;
	SetProgressSuccess(progress, iBaseMtm.Entry().Entry().Id());
	op = CMsvCompOperation::NewL(Session(), Type(), progress, 
				iServiceId, aStatus);
	
    return op;
	}

// ----------------------------------------------------------------------------
// Edit selection
//
CMsvOperation* CTextMtmUi::EditL(TRequestStatus& aStatus, const CMsvEntrySelection& aSelection)
	{
	__ASSERT_DEBUG(aSelection.Count(), Panic(ETextMtmUiEmptySelection));
	iBaseMtm.SwitchCurrentEntryL(aSelection.At(0));
	return EditL(aStatus);
	}


// ----------------------------------------------------------------------------
// View
//
CMsvOperation* CTextMtmUi::ViewL(TRequestStatus& aStatus)
	{
	__ASSERT_DEBUG(iBaseMtm.Entry().Entry().iType==KUidMsvMessageEntry, Panic(ETextMtmUiOnlyWorksWithMessageEntries));
	//__ASSERT_ALWAYS(iServiceId == KMsvLocalServiceIndexEntryId, Panic( ETextMtmUiNotLocalEntry));

    TMsvEntry tEntry = iBaseMtm.Entry().Entry();

	// Set the entry status to "read" now that we are about to view it
    if (iServiceId == KMsvLocalServiceIndexEntryId)
        {
    	tEntry.SetUnread(EFalse);
    	iBaseMtm.Entry().ChangeL(tEntry);			
        CallNewMessagesL();
        }
    
    return LaunchViewerApplicationL(aStatus, iBaseMtm.Entry().Entry().Id());

	}


// ----------------------------------------------------------------------------
// View selection
//
CMsvOperation* CTextMtmUi::ViewL(TRequestStatus& aStatus, const CMsvEntrySelection& aSelection)
	{
	__ASSERT_DEBUG(aSelection.Count(), Panic(ETextMtmUiEmptySelection));
	iBaseMtm.SwitchCurrentEntryL(aSelection.At(0));
	return ViewL(aStatus);
	}


// ----------------------------------------------------------------------------
// Deletes selected entries
//
CMsvOperation* CTextMtmUi::DeleteFromL(const CMsvEntrySelection& aSelection,
									   TRequestStatus& aStatus)
	{
	__ASSERT_DEBUG(aSelection.Count(), Panic(ETextMtmUiEmptySelection));

	ValidateSelectionL(BaseMtm().Entry(),aSelection);
	return BaseMtm().Entry().DeleteL(aSelection, aStatus);
	}


// ----------------------------------------------------------------------------
CMsvOperation* CTextMtmUi::DeleteServiceL(const TMsvEntry& aService, TRequestStatus& aStatus)
	{
	// remove settings from cenrep
	CTextMtmClient& mtm = static_cast<CTextMtmClient&>(BaseMtm());
	mtm.Settings().DeleteSettingsL(aService.Id());
	return CBaseMtmUi::DeleteServiceL(aService, aStatus);
	}


// ----------------------------------------------------------------------------
// Copies entries in selection to the current context
//

CMsvOperation* CTextMtmUi::CopyToL(const CMsvEntrySelection& aSelection,
											TRequestStatus& aStatus)
	{

	return DoCopyMoveToL(aSelection, aStatus, ETrue);
	}


// ----------------------------------------------------------------------------
// Moves entries in selection to the current context
//

CMsvOperation* CTextMtmUi::MoveToL(const CMsvEntrySelection& aSelection,
											TRequestStatus& aStatus)
	{
	return DoCopyMoveToL(aSelection, aStatus, EFalse);
	}


// ----------------------------------------------------------------------------
// Copies entries in selection from current context to aTargetId id
//
CMsvOperation* CTextMtmUi::CopyFromL(const CMsvEntrySelection& aSelection,
									 TMsvId aTargetId, TRequestStatus& aStatus)
	{
	return DoCopyMoveFromL(aSelection, aTargetId, aStatus, ETrue);
	}


// ----------------------------------------------------------------------------
// Moves entries in selection from current context to aTargetId id
//
CMsvOperation* CTextMtmUi::MoveFromL(const CMsvEntrySelection& aSelection,
									 TMsvId aTargetId, TRequestStatus& aStatus)
	{
	return DoCopyMoveFromL(aSelection, aTargetId, aStatus, EFalse);
	}


// ----------------------------------------------------------------------------
// Does copy/move of entries in selection from current context to aTargetId id
//
CMsvOperation* CTextMtmUi::DoCopyMoveFromL(const CMsvEntrySelection& aSelection,
									 TMsvId aTargetId, TRequestStatus& aStatus, TBool aCopy)
	{
	__ASSERT_DEBUG(aSelection.Count(), Panic(ETextMtmUiEmptySelection));

	const TMsvEntry& context=BaseMtm().Entry().Entry();
	__ASSERT_ALWAYS(context.iType.iUid==KUidMsvServiceEntryValue ||
		context.iType.iUid==KUidMsvFolderEntryValue, Panic(ETextMtmUiWrongEntryType));

	ValidateSelectionL(BaseMtm().Entry(),aSelection);

	// Call the CMsvEntry copy/move functions: this will in turn call the Message Server
	CMsvOperation* op=NULL;
	if (aCopy)
		op=BaseMtm().Entry().CopyL(aSelection, aTargetId, aStatus);
	else
		op=BaseMtm().Entry().MoveL(aSelection, aTargetId, aStatus);

	return op;
	}


// ----------------------------------------------------------------------------
// Perform a copy/move (depending on value of aAction)
//
CMsvOperation* CTextMtmUi::DoCopyMoveToL(const CMsvEntrySelection& aSelection,
											TRequestStatus& aStatus, TBool aCopy)
	{
	__ASSERT_DEBUG(aSelection.Count(), Panic(ETextMtmUiEmptySelection));

	const TMsvEntry& context=BaseMtm().Entry().Entry();
	__ASSERT_ALWAYS(context.iType.iUid==KUidMsvServiceEntryValue ||
		context.iType.iUid==KUidMsvFolderEntryValue, Panic(ETextMtmUiWrongEntryType));

	// Find selection parent
	CMsvEntry* sourceEntry=Session().GetEntryL(aSelection.At(0));
	CleanupStack::PushL(sourceEntry);

	TMsvId parent=sourceEntry->Entry().Parent();
	sourceEntry->SetEntryL(parent);

	ValidateSelectionL(*sourceEntry,aSelection);

	// Call the CMsvEntry copy/move function: this will in turn call the Message Server
	CMsvOperation* op=NULL;
	if (aCopy)
		op=sourceEntry->CopyL(aSelection, context.Id(), aStatus);
	else
		op=sourceEntry->MoveL(aSelection, context.Id(), aStatus);

	CleanupStack::PopAndDestroy();// sourceEntry

	return op;
	}


// ----------------------------------------------------------------------------
// Check selection and confirm it contains only messages. Server-side doesn't handle folders
//
void CTextMtmUi::ValidateSelectionL(const CMsvEntry& aParent,
												 const CMsvEntrySelection& aSelection)
	{
	// We have a ready-made way of getting a list of the message children to check against
	CMsvEntrySelection* msgChildren=aParent.ChildrenWithTypeL(KUidMsvMessageEntry);
	CleanupStack::PushL(msgChildren);

	// Check each aSelection entry is a child message
	const TInt nChildren=aSelection.Count();
	for (TInt i=0; i<nChildren; i++)
		if ( msgChildren->Find(aSelection[i] ) == KErrNotFound )
			User::Leave(KErrNotSupported);
	CleanupStack::PopAndDestroy(msgChildren);
	}



// ----------------------------------------------------------------------------
// Call MTM-specific function synchronously
//
void CTextMtmUi::InvokeSyncFunctionL(TInt aFunctionId, const CMsvEntrySelection& aSelection,
									 TDes8& aParameter)
// Call MTM-specific function synchronously
	{
	if (aFunctionId==ETxtuCommandRefreshMBox)
		{
		CBaseMtmUi::InvokeSyncFunctionL(KTXTMTMRefresh, aSelection, aParameter);
        iServiceId = aSelection[0];
        CallNewMessagesL();
		}
	else 
		{
		CBaseMtmUi::InvokeSyncFunctionL(aFunctionId, aSelection, aParameter);
		}
	}

// ----------------------------------------------------------------------------
// Call MTM-specific function asynchronously
//
CMsvOperation* CTextMtmUi::InvokeAsyncFunctionL(TInt aFunctionId, const CMsvEntrySelection& aSelection,
												TRequestStatus& aCompletionStatus, TDes8& aParameter)
	{
	if (aFunctionId==ETxtuCommandMessage)
		{
		return CBaseMtmUi::InvokeAsyncFunctionL(KTXTMTMMessageCommand, aSelection, aCompletionStatus, aParameter);
		}
	else 
        return CBaseMtmUi::InvokeAsyncFunctionL(aFunctionId, aSelection, aCompletionStatus, aParameter);
	}


void CTextMtmUi::CallNewMessagesL() 
    {
    MNcnNotification* notification = NULL;

    CDesCArrayFlat* dummyArray = new (ELeave) CDesCArrayFlat( 1 );
    CleanupStack::PushL( dummyArray );

    //Connect to NCN
    TRAP_IGNORE( notification =
        MNcnNotification::CreateMNcnNotificationL() );

    if ( notification )
        {
        notification->NewMessages(
            iServiceId,  MNcnNotification::EIndicationNormal , *dummyArray );
        }
  
    CleanupStack::PopAndDestroy( dummyArray );
    dummyArray = NULL;
    delete notification;
    notification = NULL;    
    } 


// ----------------------------------------------------------------------------
// Reply to message - no UI support
//
CMsvOperation* CTextMtmUi::ReplyL(TMsvId /*aDestination*/, TMsvPartList /*aPartlist*/, TRequestStatus& /*aCompletionStatus*/)
	{
	User::Leave(KErrNotSupported);
	return NULL;
	}


// ----------------------------------------------------------------------------
// Forwarded message - no UI support
//
CMsvOperation* CTextMtmUi::ForwardL(TMsvId /*aDestination*/, TMsvPartList /*aPartlist*/, TRequestStatus& /*aCompletionStatus*/)
	{
	User::Leave(KErrNotSupported);
	return NULL;
	}


// ----------------------------------------------------------------------------
//	Progress information
//
TInt CTextMtmUi::GetProgress(const TDesC8& aProgress, TBuf<EProgressStringMaxLen>& aReturnString,
		TInt& aTotalEntryCount, TInt& aEntriesDone,TInt& aCurrentEntrySize, TInt& aCurrentBytesTrans) const
	{
	TTxtProgressBuf paramPack;
	// check that the progress descriptor passed to this method is valid
    if (aProgress.Length() != paramPack.Length())
		return KErrBadDescriptor;

	// extract the progress information from the progress buffer
	paramPack.Copy(aProgress);
	TTxtProgress progress=paramPack();

    // clear the return string
	aReturnString.Zero();

	// write error information into the return string
	if (progress.iErrorCode==KErrNone)
        {
        HBufC* text = StringLoader::LoadL(R_TEXTMTM_PROGRESS_OK_TEXT, iCoeEnv );
		aReturnString.Append(*text);
        delete text;
        }
	else
		{
        HBufC* text = StringLoader::LoadL(R_TEXTMTM_PROGRESS_ERROR_TEXT, iCoeEnv );
		aReturnString.Append(*text);
        delete text;
		aReturnString.AppendNum(progress.iErrorCode);
		}

	// Populate method parameters with information extracted from progress structure
	aTotalEntryCount=progress.iTotalMsgs;
	aEntriesDone=progress.iMsgsProcessed;

	// TTxtProgress doesn't hold anything about these attributes, so zero them
	aCurrentEntrySize=0;
	aCurrentBytesTrans=0;

	return KErrNone;
	}


// ----------------------------------------------------------------------------
// Specific to CTextMtmUi
//
CMsvOperation* CTextMtmUi::LaunchEditorApplicationL(TRequestStatus& aStatus, TMsvId aId, TBool /*aReadOnly*/)
	{
	CTxtMtmEditorOperation* op = CTxtMtmEditorOperation::NewL(aId,CTxtMtmEditorOperation::EEdit,Session(),aStatus, *this);
	return op;
	}


// ----------------------------------------------------------------------------
// Specific to CTextMtmUi
//
CMsvOperation* CTextMtmUi::LaunchViewerApplicationL(TRequestStatus& aStatus, TMsvId aId)
	{

	CTxtMtmEditorOperation* op = CTxtMtmEditorOperation::NewL(aId,CTxtMtmEditorOperation::EView,Session(),aStatus, *this);
	return op;
	}


// ----------------------------------------------------------------------------
// Little utility function to set progress info
//
void CTextMtmUi::SetProgressSuccess(TPckgBuf<TMsvLocalOperationProgress>& aProgress,TMsvId aId)
	{
	aProgress().iTotalNumberOfEntries=1;
	aProgress().iNumberCompleted=1;
	aProgress().iId=aId;

	}



